% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_multidyads_utilities.R
\name{plot_sim_comp}
\alias{plot_sim_comp}
\title{Plot comparison of multiple similarity measures}
\usage{
plot_sim_comp(comparison_df, title)
}
\arguments{
\item{comparison_df}{A data frame output from compare_sim_meas()}

\item{title}{A string specifying the plot title}
}
\value{
A ggplot object
}
\description{
This function creates a ggplot object comparing multiple similarity measures for the same set of dyads.
}
\examples{
topic_similarities <- list("1" = c(0.5, 0.6, 0.7), "2" = c(0.4, 0.5, 0.6))
lexical_similarities <- list("1" = c(0.6, 0.7, 0.8), "2" = c(0.5, 0.6, 0.7))
comparison_df <- compare_sim_meas(
  list(topic_similarities, lexical_similarities),
  c("Topic", "Lexical")
)
plot_sim_comp(comparison_df, "Comparison of Similarity Measures")
print(plot)
}
