% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_multidyads.R
\name{timing_sim_dyads}
\alias{timing_sim_dyads}
\title{Calculate timing similarity for multiple dyads}
\usage{
timing_sim_dyads(conversations)
}
\arguments{
\item{conversations}{A data frame with columns 'dyad_id', 'speaker', and 'processed_text'}
}
\value{
A list containing timing similarity for each dyad and the overall average similarity
}
\description{
This function calculates an extended measure of timing similarity for multiple dyads.
}
\examples{
convs <- data.frame(
  dyad_id = c(1, 1, 1, 1, 2, 2, 2, 2),
  speaker = c("A", "B", "A", "B", "C", "D", "C", "D"),
  processed_text = c("i love pizza", "me too favorite food",
                     "whats your favorite topping", "enjoy pepperoni mushrooms",
                     "i prefer pasta", "pasta delicious like spaghetti carbonara",
                     "ever tried making home", "yes quite easy make")
)
timing_sim_dyads(convs)
}
