# Generated by LaTeX DogWagger Version 4.0.5 from file <NCTLL_904.tex>
# Date: [2020-9-17 13:16:5] 
# Do NOT edit this file. Edit the LaTeX source!!

# - <Section 10> - 
#' Plot time course of coronavirus case incidence and deaths for one country 
#'
#'   The daily case rate is also shown as a smoothed curve.
#'   The smoothed death incidence is MULTIPLIED x5 to highlight
#'   its relationship to the incidence curve. See grown-up documentation (LyX) 
#' 
#' @param country : no default
#' @param pdf : defaults to FALSE. If TRUE, writes to country_name_new.pdf
#'     i.e. '_new.pdf' is appended to formal country name. 
#'     If the country name contains spaces ' ' they are changed to underscores '_' 
#' @param smooth : default TRUE show smoothed (red) curve 
#' @param deaths : default TRUE show deaths
#' 
#' @keywords corona single country 
#' @export 
#' @import ggplot2 
#' @importFrom stats loess
#' @importFrom stats na.exclude
#' @importFrom stats predict
#' @examples
#' corona_country('United States'); 
#' corona_country('Taiwan'); 

corona_country <- function(country, pdf=FALSE, smooth=TRUE, deaths=TRUE)
{ cc <- country_code(country, owid); 
  CTRY <- owid[ owid$iso_code==cc, ]; 
if( nrow(CTRY) < 1 )
  { stop( paste('No data for ', country) ); 
  }; 
  CTRY$fivetimes <- 5*CTRY$new_deaths; 
  ctitle <- country; 
  ymax <- max(CTRY$new_cases); 
  yco <- 0.8 * ymax; 
  cols <- ncol(CTRY);
  xco <- CTRY$date[as.integer(0.5*cols)];
  smoothing <- 0.2; 
  FIVETIMES='red';
  NEWCASES='grey40'; 
  NEWDEATHS='darkred';
  SMOOT='black';

  lty <- 'dashed'; 
  fname <- country; 
  fname <- gsub( ' ', '_', fname); # replace ' ' with '_' 
if(! deaths)
  { fname <- paste(fname, '_simple', sep=''); 
  }; 
if(! smooth)
  { lty <- 'solid'; # cases are dashed if smoothed line drawn.
    fname <- paste(fname, '_plain', sep=''); 
  }; 
  legendtitle = 'Daily cases'; 
  bar = c(NEWCASES, SMOOT, NEWDEATHS, FIVETIMES);
  labs = c('new cases', 'smoothed', 'new deaths', '5x new deaths, smoothed'); 
  fname <- paste(fname, '_new.pdf', sep='' ); 
  fivelabel <- paste(intToUtf8(215), '5'); # avoid UTF8 in R code! 215 is math 'times'
  corona_pdf(fname, 11, 7, pdf); 
  myplot <- ggplot(CTRY, aes(x=date)) + 
       # bizarre colour mapping: 
       scale_color_identity(guide = 'legend', name=legendtitle, breaks=bar, labels=labs) + 
       geom_line( aes(y=.data$new_cases, colour=NEWCASES), linetype=lty ) + 
       scale_x_date(breaks='1 month', date_labels = "%b") + 
       labs(title=ctitle, x='Date', y='Cases/Deaths per day'); 
if(smooth)
  { myplot <- myplot + 
      geom_smooth( aes(y=.data$new_cases, colour=SMOOT), 
                   method='loess', span=smoothing, linetype='solid' ); 
  }; 
if(deaths)
  { myplot <- myplot + geom_line( aes(y=.data$new_deaths, colour=NEWDEATHS), linetype='solid' );
  if(smooth)
    { yup <- 0.08 * max(CTRY$new_cases); 
      Lfive <- loess(fivetimes~as.numeric(date), data=CTRY, span=smoothing, na.action=na.exclude); 
      Pfive <- predict(Lfive); 
      yfive <- max( Pfive );
      xfive <- min( CTRY$date[Pfive==yfive] ); 
      myplot <- myplot + 
        annotate('text', x=xfive, y=(yfive+yup), colour=FIVETIMES, size=16, label=fivelabel) + 
        geom_smooth( aes(y=.data$fivetimes, colour=FIVETIMES), 
                     method='loess', span=smoothing, linetype='solid' ); 
    }; 
  }; 
  corona_print(myplot); 
  corona_pdf_off(fname, pdf); 
}
# -END OF FILE- 
