% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corvisualize.R
\name{corvisualize}
\alias{corvisualize}
\title{Visualize the correlation coefficient geometrically.}
\usage{
corvisualize(data = NULL, x = "x1", y = "x2", visualize = TRUE)
}
\arguments{
\item{data}{A data.frame with two columns, which shall be correlated by Pearson's product-moment method.}

\item{x}{A single character, i.e., the column name of the data.frame which shall be the predictor (independent variable) in the simple linear regression.}

\item{y}{A single character, i.e., the column name of the data.frame which shall be the outcome (dependent variable) in the simple linear regression.}

\item{visualize}{A single boolean value (default: TRUE), which determines whether the data shall be visualized.}
}
\value{
a list with results (name: res), and one graph as elements (name: anglePlot).
res is a list with 13 objects:
\enumerate{
\item covMat Covariance matrix of predictor and outcome.
\item covPredMat Covariance matrix of predictor and the predicted outcome, based on the simple linear regression estimates.
\item corMat Correlation matrix of predictor and outcome.
\item spreadMat Square root of the variance of the predictor and the variance of the outcome. If the angle is greater than 90 degrees, the spread of the predictor is multiplied by minus one.
\item angle The angle between predictor and outcome: In R, compute: acos(cor(predictor,outcome))*180/pi.
\item rsquared Explained variance of the outcome variable.
\item errorVariance Difference between the variance of the outcome and the explained variance of the (predicted) outcome variable.
\item errorSpread Square root of the error variance.
\item observedSpread Square root of the variance of the outcome variable.
\item yhatSpread Square root of the difference between outcome variance and variance of the predicted outcome. If the angle is greater than 90 degrees, yhatSpread is multiplied by minus one.
\item bWeight The regression weight (slope) of the simple linear regression of the predictor and the outcome variable.
\item betaWeight Same as bWeight, if the predictor and the outcome have both been scaled (mean = 0, standard deviation = 1).
\item anglePlot Visualization of the regression weight, unless the function argument visualize has been set to FALSE.
}
}
\description{
Visualize the correlation coefficient geometrically, i.e., use the angle between the linear vector that represents the predictor and the linear vector that represents the outcome, show where the dropping of the perpendicular lands on the linear vector that represents the predictor in the two-dimensional linear space, finally read b regression weight from the simple linear regression between predictor and outcome; or read the beta regression weight, in case the predictor and outcome have been scaled (mean = zero, standard deviation = one).
}
\details{
Any textbook on linear algebra and/or analytic geometry usually contains at least one numeric example and a geometric visualization of a correlation between two continuous variables. I want to express my gratitude to Dr. Johannes Andres (who taught statistics as well as multivariate statistics to psychology students, of which I was one).
}
\examples{
positiveCorDat <- data.frame(x1=c(5,9,3,6,2,9,3,7,2,8),
                      x2=c(2,6,7,8,3,5,5,8,3,9))
negativeCorDat <- data.frame(x1=c(5,9,3,6,2,9,3,7,2,8),
                      x2=c(5,7,9,2,5,5,8,1,9,8))
# Run corvisualize with positiveCorDat.
corvisualize(data=positiveCorDat, x="x1", y="x2", visualize=TRUE)
# Run corvisualize with negativeCorDat.
corvisualize(data=negativeCorDat, x="x1", y="x2", visualize=TRUE)
}
\references{
\insertRef{boyer1949invention}{correlatio}

\insertRef{gniazdowski2013geometric}{correlatio}

\insertRef{graffelman2013linear}{correlatio}

\insertRef{graffelman2023improved}{correlatio}
}
\author{
Marcel Miché
}
