% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R, R/methods_print.R
\name{display.easycormatrix}
\alias{display.easycormatrix}
\alias{print_md.easycorrelation}
\alias{print_html.easycorrelation}
\alias{print_md.easycormatrix}
\alias{print_html.easycormatrix}
\title{Export tables into different output formats}
\usage{
\method{display}{easycormatrix}(
  object,
  format = "markdown",
  digits = 2,
  p_digits = 3,
  stars = TRUE,
  include_significance = NULL,
  ...
)

\method{print_md}{easycorrelation}(x, digits = NULL, p_digits = NULL, stars = NULL, ...)

\method{print_html}{easycorrelation}(x, digits = NULL, p_digits = NULL, stars = NULL, ...)

\method{print_md}{easycormatrix}(
  x,
  digits = NULL,
  p_digits = NULL,
  stars = NULL,
  include_significance = NULL,
  ...
)

\method{print_html}{easycormatrix}(
  x,
  digits = NULL,
  p_digits = NULL,
  stars = NULL,
  include_significance = NULL,
  ...
)
}
\arguments{
\item{object, x}{An object returned by
\code{\link[=correlation]{correlation()}} or its summary.}

\item{format}{String, indicating the output format. Currently, only
\code{"markdown"} is supported.}

\item{digits, p_digits}{To do...}

\item{stars}{To do...}

\item{include_significance}{To do...}

\item{...}{Currently not used.}
}
\value{
A character vector. If \code{format = "markdown"}, the return value
will be a character vector in markdown-table format.
}
\description{
Export tables (i.e. data frame) into different output formats.
\code{print_md()} is a alias for \code{display(format = "markdown")}. Note that
you can use \code{format()} to get the formatted table as a dataframe.
}
\details{
\code{display()} is useful when the table-output from functions,
which is usually printed as formatted text-table to console, should
be formatted for pretty table-rendering in markdown documents, or if
knitted from rmarkdown to PDF or Word files.
}
\examples{
data(iris)
corr <- correlation(iris)
display(corr)

s <- summary(corr)
display(s)
}
