% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_cosinor.R
\name{test_cosinor}
\alias{test_cosinor}
\title{Test for differences in a cosinor model}
\usage{
test_cosinor(object, x_str, param = "amp")
}
\arguments{
\item{object}{An object of class \code{cosinor.lm}}

\item{x_str}{Character naming the covariate whose amplitude/acrophase will be tested}

\item{param}{Character string naming the parameter to test, either "amp" for
amplitude or "acr" for acrophase}
}
\description{
Given a time variable and optional covariates, generate inference a cosinor
fit. For the covariate named (or vector of covariates), this function
performs a Wald test comparing the group with covariates equal to 1 to the
group with covariates equal to 0. This may not be the desired result for
continuous covariates.
}
\examples{

fit <- cosinor.lm(Y ~ time(time) + X + amp.acro(X), data = vitamind)
test_cosinor(fit, "X", "amp")

}
