% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{ca2cm}
\alias{ca2cm}
\title{Covariance array to covariance matrix}
\usage{
ca2cm(A)
}
\arguments{
\item{A}{a covariance array of dimension p1*p2*p1*p2.}
}
\value{
a p1*p2 by p1*p2 covariance matrix.
}
\description{
Reshape a covariance array to a covariance matrix.
}
\examples{
p1<-4 ; p2<-7 ; p<-p1*p2 

S<-rWishart(1,p,diag(p))[,,1] 
A<-cm2ca(S,p1,p2) 
range(S-ca2cm(A)) 

}
\author{
Peter Hoff
}
