% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{cm2ca}
\alias{cm2ca}
\title{Covariance matrix to covariance array}
\usage{
cm2ca(S, p1, p2)
}
\arguments{
\item{S}{a covariance matrix of dimension (p1p2)*(p1p2).}

\item{p1}{the row dimension.}

\item{p2}{the column dimension.}
}
\value{
a four-way array where entry i1,j1,i2,j2 gives the covariance 
between element i1,j1 and element i2,j2 of a random matrix.
}
\description{
Reshape a covariance matrix to a covariance array.
}
\examples{
p1<-4 ; p2<-7 ; p<-p1*p2 
 
S<-rWishart(1,p,diag(p))[,,1] 
A<-cm2ca(S,p1,p2) 
range(S-ca2cm(A)) 

}
\author{
Peter Hoff
}
