% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descarga_datos_abiertos_aux.R
\encoding{UTF-8}
\name{descarga_db}
\alias{descarga_db}
\alias{descarga_diccionario}
\alias{descarga_db_datos_abiertos_tbl}
\alias{descarga_db_diccionario_ssa}
\alias{unzip_db_datos_abiertos_tbl}
\alias{unzip_db_diccionario_ssa}
\alias{parse_db_diccionario_ssa}
\alias{parse_db_datos_abiertos_tbl}
\alias{pega_db_datos_abiertos_tbl_y_diccionario}
\title{Auxiliares para la descarga de datos abiertos}
\usage{
descarga_db(
  read_format = c("duckdb", "tibble"),
  tblname = "covidmx",
  pragma_memory_limit = Sys.getenv("pragma_memory_limit"),
  drv = duckdb::duckdb(),
  dbdir = tempfile(fileext = ".duckdb"),
  colClasses = get_col_class(),
  sites.covid = get_sites_covid(),
  download_process = c("pins", "download.file"),
  unzip_command = Sys.getenv("unzip_command"),
  unzip_args = Sys.getenv("unzip_args"),
  check_unzip_install = TRUE,
  clear_zip = (download_process[1] != "pins"),
  clear_csv = TRUE,
  force_download = FALSE,
  show_warnings = TRUE,
  datos_abiertos_zip_paths = NULL,
  datos_abiertos_unzipped_path = NULL,
  datos_abiertos_tbl = NULL,
  quiet = FALSE,
  board_url_name = "datos_abiertos",
  cache = NULL,
  use_cache_on_failure = TRUE,
  download_file_args = list(method = "curl", destfile = tempfile(), quiet = quiet),
  descarga_db_datos_abiertos_tbl_args = list(),
  ...
)

descarga_diccionario(
  download_process = c("pins", "download.file"),
  site.covid.dic = get_site_dic(),
  quiet = FALSE,
  clear_zip = download_process[1] != "pins",
  clear_csv = TRUE,
  diccionario_zip_path = NULL,
  diccionario_unzipped_path = NULL,
  diccionario = NULL,
  board_url_name_dict = "diccionario_covid",
  cache_diccionario = NULL,
  use_cache_on_failure = TRUE,
  force_download = FALSE,
  show_warnings = TRUE,
  download_file_args_dict = list(method = "curl", destfile = tempfile(), quiet = quiet),
  unzip_args_dict = list(exdir = ".", overwrite = TRUE),
  descarga_db_diccionario_ssa_args = list()
)

descarga_db_datos_abiertos_tbl(
  download_process = c("pins", "download.file"),
  sites.covid = get_sites_covid(),
  quiet = FALSE,
  board_url_name = "datos_abiertos",
  cache = NULL,
  use_cache_on_failure = TRUE,
  force_download = FALSE,
  show_warnings = TRUE,
  download_file_args = list(method = "curl", destfile = tempfile(), quiet = quiet),
  ...
)

descarga_db_diccionario_ssa(
  download_process = c("pins", "download.file"),
  site.covid.dic = get_site_dic(),
  quiet = FALSE,
  board_url_name_dict = "diccionario_covid",
  cache_diccionario = NULL,
  use_cache_on_failure = TRUE,
  force_download = FALSE,
  show_warnings = TRUE,
  download_file_args_dict = list(method = "curl", destfile = tempfile(), quiet = quiet),
  ...
)

unzip_db_datos_abiertos_tbl(
  datos_abiertos_zip_paths,
  unzip_command = Sys.getenv("unzip_command"),
  unzip_args = Sys.getenv("unzip_args"),
  check_unzip_install = TRUE,
  quiet = FALSE,
  clear_zip = FALSE
)

unzip_db_diccionario_ssa(
  diccionario_zip_path,
  unzip_args_dict = list(exdir = ".", overwrite = TRUE),
  clear_zip = FALSE
)

parse_db_diccionario_ssa(diccionario_unzipped_path, clear_csv = FALSE)

parse_db_datos_abiertos_tbl(
  datos_abiertos_unzipped_path,
  read_format = c("duckdb", "tibble"),
  pragma_memory_limit = Sys.getenv("pragma_memory_limit"),
  dbdir = tempfile(fileext = ".duckdb"),
  drv = duckdb::duckdb(),
  colClasses = get_col_class(),
  tblname = "covidmx",
  quiet = TRUE,
  clear_csv = FALSE,
  ...
)

pega_db_datos_abiertos_tbl_y_diccionario(datos_abiertos_tbl, diccionario)
}
\arguments{
\item{read_format}{(\strong{opcional}) \code{"duckdb"} o \code{"tibble"} establece el formato
de lectura de la base de datos. En la mayoria de los casos \code{"tibble"} va a
resultar en un error de memoria. La opcion de \code{"duckdb"} siempre es mas rapida por lo cual
es el default.}

\item{tblname}{(\strong{opcional})  Nombre de la tabla de \code{duckdb} donde guardar los datos por
default se llama \code{covidmx}. Solo es relevante si estas usando el mismo \code{dbdir} para otro
proyecto distinto.}

\item{pragma_memory_limit}{(\strong{opcional}) Limite de memoria para el programa
(ver \href{https://duckdb.org/docs/sql/pragmas}{PRAGMAS}). Cambialo a que sea mas o menos la mitad
de tu RAM. La forma mas sencilla es como una variable ambiental con
\code{Sys.setenv('pragma_memory_limit' = '1GB')} por ejemplo para un limite de 1 gigabyte.}

\item{drv}{(\strong{opcional}) Un  driver para \code{dbConnect} (default \code{duckdb::duckdb()})}

\item{dbdir}{(\strong{opcional}) Direccion donde guardar la base de datos con terminacion \code{.duckdb}.
Corresponde al argumento de \code{\link[duckdb:duckdb]{duckdb::dbConnect__duckdb_driver()}}}

\item{colClasses}{(\strong{opcional}) Clases de la columna para leer en \code{duckdb::read_csv_duckdb()}.}

\item{sites.covid}{(\strong{opcional})  Sitios web con el vinculo a los archivos \code{.zip} de l
os datos abiertos. Puedes cambiarlo por uno de los historicos, por ejemplo. La estructura es
\code{c("nombre" = "url", "nombre2" = "url2")}. La ultima verificacion del sitio web default fue
el 6 de septiembre del 2022.}

\item{download_process}{(\strong{opcional})  Metodo para descargar ya sea \code{pins} o \code{download.file}.
Se recomienda \code{pins} pues guarda en memoria la fecha de la ultima descarga y analiza
si ha pasado mas de un dia desde la descarga. En caso afirmativo verifica si el
archivo ha cambiado y si hubo cambios entonces lo descarga.}

\item{unzip_command}{(\strong{opcional}) Forma de extraer la base de datos de datos abiertos
si \code{unzip} falla.
La forma de llamarla es con \code{system2(unzip_command, args = c(unzip_args, file_download_data))}.}

\item{unzip_args}{(\strong{opcional}) Argumentos de extraccion de la base de datos de datos abiertos
si \code{unzip} falla.
La forma de llamarla es con \code{system2(unzip_command, args = c(unzip_args, file_download_data))}.}

\item{check_unzip_install}{(\strong{opcional}) Bandera de verificacion para checar si tienes
lo necesario para unzippear los datos en el caso de que \code{unzip} no sirva.}

\item{clear_zip}{(\strong{opcional}) Si borrar los archivos \code{.zip} descargados para el diccionario
y los datos abiertos. No se recomienda si estas usando \code{pins}. Ve la nota para mas informacion.}

\item{clear_csv}{(\strong{opcional}) Si borrar los archivos \code{.csv} que se generan despues de abrir
el zip. El default es que si pues en general solo requieres el \code{duckdb}.}

\item{force_download}{(\strong{opcional}) Analiza si cambio el pin y descarga datos nuevos en caso
afirmativo aunque haya pasado menos de un dia.}

\item{show_warnings}{(\strong{opcional}) si arrojar \code{warnings}}

\item{datos_abiertos_zip_paths}{(\strong{opcional})  Camino a los datos abiertos si ya los
descargaste en \code{zip}}

\item{datos_abiertos_unzipped_path}{(\strong{opcional})  Camino a los datos abiertos \code{csv} si ya
los descargaste y descomprimiste el archivo \code{zip} en un \code{csv}}

\item{datos_abiertos_tbl}{(\strong{opcional}) Camino a un archivo \code{.duckdb} con los datos formateados}

\item{quiet}{(\strong{opcional}) Variable para no mostrar mensajes}

\item{board_url_name}{(\strong{opcional}) Establece el nombre del \code{pins::board_url} para
los datos abiertos (si ya usas pins para que no se empalme).
Por default se llama \code{datos_abiertos}}

\item{cache}{parametro para el cache de \code{pins::board_url}}

\item{use_cache_on_failure}{(\strong{opcional}) Booleana. Establece que si no se pueden descargar
datos nuevos utilice los que tenga en memoria. Por default es \code{TRUE}.}

\item{download_file_args}{(\strong{opcional}) Lista de argumentos adicionales para \code{download.file}
de los datos si se elige este metodo para descargar.}

\item{descarga_db_datos_abiertos_tbl_args}{(\strong{opcional}) Lista con argumentos adicionales
para el \code{pins::pin_download} de datos abiertos}

\item{...}{Parametros adicionales para \code{pins::pin_download}}

\item{site.covid.dic}{(\strong{opcional})  Sitio desde el cual descarga del diccionario de datos.
La ultima verificacion del sitio fue el 6 de septiembre 2022.}

\item{diccionario_zip_path}{(\strong{opcional})  Camino al diccionario si ya losdescargaste en \code{zip}}

\item{diccionario_unzipped_path}{(\strong{opcional})  Camino al diccionario \code{csv} si ya
lo descargaste y descomprimiste el archivo \code{zip} en un \code{csv}}

\item{diccionario}{(\strong{opcional})  Lo que resulta de realizar una descarga del diccionario
usando \code{descarga_diccionario}}

\item{board_url_name_dict}{(\strong{opcional}) Establece el nombre del \code{pins::board_url} para los
datos abiertos. Por default se llama \code{diccionario_covid}}

\item{cache_diccionario}{(\strong{opcional}) Direccion donde guardar el diccionario en memoria
usando \code{pins} para no tener que volver a descargarlo si nada ha cambiado}

\item{download_file_args_dict}{(\strong{opcional}) Lista de argumentos adicionales
para \code{download.file} del diccionario si se elige este metodo de descarga.}

\item{unzip_args_dict}{(\strong{opcional}) Lista de argumentos para usar \code{utils::unzip} en el
diccionario de datos.}

\item{descarga_db_diccionario_ssa_args}{(\strong{opcional}) Lista con argumentos adicionales para el
\code{pins::pin_download} de datos abiertos}
}
\value{
Lista de valores:
\itemize{
\item dats        - Tabla conectada mediante \code{duckdb::dbConnect__duckdb_driver()} (si \code{duckdb}) o
tibble (si \code{tibble})
\item disconnect  - Funcion para cerrar la conexion a la base de datos.
\item dict        - Lista de \code{tibble}s con el diccionario de datos para cada variable
}
}
\description{
Conjunto de funciones para apoyar la descarga de datos abiertos de
la Direccion General de Epidemiologia (DGE)

La funcion de descarga principal es \code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} llama las siguientes funciones
en orden:
\itemize{
\item \code{\link[=descarga_diccionario]{descarga_diccionario()}} Se encarga de descargar y formatear el diccionario de datos
\item \code{\link[=descarga_db]{descarga_db()}} Se encarga de descargar y formatear la base de datos
\item \code{\link[=pega_db_datos_abiertos_tbl_y_diccionario]{pega_db_datos_abiertos_tbl_y_diccionario()}} Pega ambos en el formato lista de \code{covidmx}
}

A su vez \code{\link[=descarga_diccionario]{descarga_diccionario()}} ejecuta las siguientes para obtener el diccionario de datos:
\itemize{
\item \code{\link[=descarga_db_diccionario_ssa]{descarga_db_diccionario_ssa()}} Descarga el diccionario de la DGE
\item \code{\link[=unzip_db_diccionario_ssa]{unzip_db_diccionario_ssa()}} Libera el archivo \code{zip} descargado
\item \code{\link[=parse_db_diccionario_ssa]{parse_db_diccionario_ssa()}} Genera una lista de tiblles con el diccionario por variable
}

Por otro lado,\code{\link[=descarga_db]{descarga_db()}} ejecuta las siguientes para obtener los datos abiertos:
\itemize{
\item \code{\link[=descarga_db_datos_abiertos_tbl]{descarga_db_datos_abiertos_tbl()}} Descarga las bases de datos de covid de la DGE
\item \code{\link[=unzip_db_datos_abiertos_tbl]{unzip_db_datos_abiertos_tbl()}} Libera el archivo \code{zip} descargado
\item \code{\link[=parse_db_datos_abiertos_tbl]{parse_db_datos_abiertos_tbl()}} Genera una base de datos en \code{duckdb} (o \code{tibble}) con la informacion
}

Si en algun momento se interrumpio la descarga o hubo problemas de conexion o detuviste
el proceso de generacion de la base de datos abiertos puedes llamar a las funciones
de \code{\link[=read_datos_abiertos]{read_datos_abiertos()}}.
}
\examples{
\donttest{
#Estos links deben omitirse en una corrida normal. Se incluyen por ahora como ejemplo
#pero las opciones site.covid.dic y sites.covid deben eliminarse de abajo.
diclink   <- "https://github.com/RodrigoZepeda/covidmx/raw/main/diccionario_datos_covid19.zip"
dlink     <- "https://github.com/RodrigoZepeda/covidmx/raw/main/datos_abiertos_covid19.zip"

#' #En el ejemplo de R por normas de CRAN tenemos que hacerlo así pero en tu
#computadora puedes solo usar descargar datos sin el if else
if (RCurl::url.exists(dlink) & RCurl::url.exists(diclink)){
  
  # Descarga solo el diccionario no oficial (omite el site.covid.dic para el de DGE)
  diccionario <- descarga_diccionario(show_warnings = FALSE, site.covid.dic = diclink)

  # O bien descarga solo los datos abiertos de ejemplo desde Github
  # omite el dlink (o cámbialo por el vínculo correcto) para descargar los datos de la DGE
  datos_abiertos <- descarga_db(sites.covid = dlink, show_warnings = FALSE)

  # Pegalos en el formato que se necesita para el resto de funciones
  datos_covid <- pega_db_datos_abiertos_tbl_y_diccionario(datos_abiertos, diccionario)

  # Desconectamos
  datos_covid$disconnect()

  # Tambien puedes descargar paso por paso
  datos_abiertos <- descarga_db_datos_abiertos_tbl(
    sites.covid = dlink,
    show_warnings = FALSE
  ) |> # Descarga
  unzip_db_datos_abiertos_tbl() |> # Unzippea
  parse_db_datos_abiertos_tbl() # Duckdb

  # O bien el diccionario
  diccionario <- descarga_db_diccionario_ssa(site.covid.dic = diclink) |> # Descarga
  unzip_db_diccionario_ssa() |> # Unzippea
  parse_db_diccionario_ssa() # Tibble

  # Si descargaste cada uno por separado necesitas la funcion pega para
  # juntarlos en un unico objeto
  datos_covid <- pega_db_datos_abiertos_tbl_y_diccionario(datos_abiertos, diccionario)
}
}
}
\seealso{
\code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} \code{\link[=read_datos_abiertos]{read_datos_abiertos()}}  \code{\link[=descarga_datos_red_irag]{descarga_datos_red_irag()}}
\code{\link[=descarga_datos_variantes_GISAID]{descarga_datos_variantes_GISAID()}}
}
