% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_data.R
\name{gen_data}
\alias{gen_data}
\title{Generate Data from the Proportional Hazards Regression Model}
\usage{
gen_data(n, beta, cont = 0, p.censor = 0)
}
\arguments{
\item{n}{number of observations.}

\item{beta}{vector of regression coefficients.}

\item{cont}{fraction of contaminated observations.}

\item{p.censor}{probability of censoring.}
}
\value{
Data frame containing the following variables:
\itemize{
\item \code{time} vector of survival times.
\item \code{status} vector of censoring status.
\item \code{X1, X2, ...} explanatory variables (their number is determined by the
dimension of vector of regression coefficients).
}
}
\description{
Generates data set from the proportional hazards regression model
without or with contamination.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
\donttest{
if (interactive()) {
gen_data(50, c(2,-2), cont = 0.05)
}
}

\dontshow{setwd(.old_wd)}
}
