% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_distance_mat.R
\name{get_distance_matrix}
\alias{get_distance_matrix}
\title{Compute all shortest distance between origin and destination nodes.}
\usage{
get_distance_matrix(
  Graph,
  from,
  to,
  algorithm = "phast",
  aggregate_aux = FALSE,
  allcores = FALSE
)
}
\arguments{
\item{Graph}{An object generated by \link{makegraph}, \link{cpp_simplify} or \link{cpp_contract} function.}

\item{from}{A vector of one or more vertices from which distances are calculated (origin).}

\item{to}{A vector of one or more vertices (destination).}

\item{algorithm}{Character. Only for contracted graph, \code{mch} for Many to many CH, \code{phast} for PHAST algorithm}

\item{aggregate_aux}{Logical. If \code{TRUE}, the additional weight is summed along shortest paths.}

\item{allcores}{Logical (deprecated). If \code{TRUE}, all cores are used.}
}
\value{
Matrix of shortest distances.
}
\description{
Compute all shortest distance between origin and destination nodes.
}
\details{
If graph is not contracted, \code{get_distance_matrix()} recursively perform Dijkstra algorithm for each \code{from} nodes.
If graph is contracted, the user has the choice between : \itemize{
  \item many to many contraction hierarchies (\code{mch}) : optimal for square matrix.
  \item PHAST (\code{phast}) : outperform mch on rectangular matrix
}

Shortest path is always computed according to the main edge weights, corresponding to the 3rd column of \code{df} argument in \code{makegraph()} function.
If \code{aggregate_aux} argument is \code{TRUE}, the values returned are the sum of auxiliary weights along shortest paths.

All algorithms are \strong{multithreaded.} \code{allcores} argument is deprecated, please use \code{RcppParallel::setThreadOptions()} to set the number of threads.

See details in package website : \url{https://github.com/vlarmet/cppRouting/blob/master/README.md}
}
\note{
It is not possible to aggregate auxiliary weights on a Graph object coming from \link{cpp_simplify} function.
}
\examples{
#Choose number of cores used by cppRouting
RcppParallel::setThreadOptions(numThreads = 1)

#Data describing edges of the graph
edges <- data.frame(from_vertex = c(0,0,1,1,2,2,3,4,4),
                    to_vertex = c(1,3,2,4,4,5,1,3,5),
                    time = c(9,2,11,3,5,12,4,1,6),
                    dist = c(5,3,4,7,5,5,5,8,7))

#Construct directed  graph with travel time as principal weight, and distance as secondary weight
graph <- makegraph(edges[,1:3], directed=TRUE, aux = edges$dist)

#Get all nodes IDs
nodes <- graph$dict$ref

# Get matrix of shortest times between all nodes : the result are in time unit
time_mat <- get_distance_matrix(graph, from = nodes, to = nodes)

# Get matrix of distance according shortest times : the result are in distance unit
dist_mat <- get_distance_matrix(graph, from = nodes, to = nodes, aggregate_aux = TRUE)

print(time_mat)
print(dist_mat)
}
\seealso{
\link{get_distance_pair}, \link{get_multi_paths}
}
