% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priority_queue.R
\name{cpp_priority_queue}
\alias{cpp_priority_queue}
\title{Create priority queue}
\usage{
cpp_priority_queue(x, sorting = c("descending", "ascending"))
}
\arguments{
\item{x}{An integer, numeric, character, or logical vector.}

\item{sorting}{\code{"descending"} (default) arranges elements in descending order with the largest element at the top. \code{"ascending"} sorts the 
elements in the opposite direction, with the smallest element at the top.}
}
\value{
Returns a CppPriorityQueue object referencing a priority_queue in C++.
}
\description{
Create a priority queue. Priority queues are hold ordered, non-unique elements.
}
\details{
A priority queue is a container, in which the order of the elements depends on their size rather than their time of insertion. As in a stack, 
elements are removed from the top.

C++ priority queue methods implemented in this package are \link{emplace}, \link{empty}, \link{pop}, \link{push}, \link{size}, and \link{top}. The 
package also adds various helper functions (\link{print}, \link{sorting}, \link{to_r}, \link{type}).

All object-creating methods in this package begin with \code{cpp_} to avoid clashes with functions from other packages, such as \code{utils::stack} and 
\code{base::vector}.
}
\examples{
q <- cpp_priority_queue(4:6)
q
# First element: 6

emplace(q, 10L)
q
# First element: 10

emplace(q, 3L)
q
# First element: 10

top(q)
# [1] 10

q <- cpp_priority_queue(4:6, "ascending")
q
# First element: 4

push(q, 10L)
q
# First element: 4

}
\seealso{
\link{cpp_queue}, \link{cpp_stack}.
}
