% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cram_ml.R
\name{cram_ml}
\alias{cram_ml}
\title{Cram ML: Simultaneous Machine Learning and Evaluation}
\usage{
cram_ml(
  data,
  batch,
  formula = NULL,
  caret_params = NULL,
  parallelize_batch = FALSE,
  loss_name = NULL,
  custom_fit = NULL,
  custom_predict = NULL,
  custom_loss = NULL,
  alpha = 0.05,
  classify = FALSE
)
}
\arguments{
\item{data}{A matrix or data frame of covariates. For supervised learning,
must include the target variable specified in formula.}

\item{batch}{Integer specifying number of batches or vector of pre-defined
batch assignments.}

\item{formula}{Formula for supervised learning (e.g., y ~ .).}

\item{caret_params}{List of parameters for caret::train() containing:
\itemize{
  \item{method: Model type (e.g., "rf", "glm", "xgbTree" for supervised learning)}
  \item{Additional method-specific parameters}
}}

\item{parallelize_batch}{Logical indicating whether to parallelize batch
processing (default = FALSE).}

\item{loss_name}{Name of loss metric (supported: "se", "logloss",
"accuracy").}

\item{custom_fit}{Optional custom model training function.}

\item{custom_predict}{Optional custom prediction function.}

\item{custom_loss}{Optional custom loss function.}

\item{alpha}{Confidence level for intervals (default = 0.05).}

\item{classify}{Indicate if this is a classification problem. Defaults to FALSE.}
}
\value{
A list containing:
\itemize{
  \item{raw_results: Data frame with performance metrics}
  \item{interactive_table: The same performance metrics in a user-friendly interface}
  \item{final_ml_model: Trained model object}
}
}
\description{
Performs the Cram method for simultaneous machine learning and evaluation.
}
\examples{
# Load necessary libraries
library(caret)

# Set seed for reproducibility
set.seed(42)

# Generate example dataset
X_data <- data.frame(x1 = rnorm(100), x2 = rnorm(100), x3 = rnorm(100))
Y_data <- rnorm(100)  # Continuous target variable for regression
data_df <- data.frame(X_data, Y = Y_data)  # Ensure target variable is included

# Define caret parameters for simple linear regression (no cross-validation)
caret_params_lm <- list(
  method = "lm",
  trControl = trainControl(method = "none")
)

nb_batch <- 5

# Run ML learning function
result <- cram_ml(
  data = data_df,
  formula = Y ~ .,  # Linear regression model
  batch = nb_batch,
  loss_name = 'se',
  caret_params = caret_params_lm
)

result$raw_results
result$interactive_table
result$final_ml_model
}
\seealso{
\code{\link[caret]{train}} for model training parameters
}
