% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{g_forest}
\alias{g_forest}
\title{Create a Combined gtsummary Table and Forest Plot}
\usage{
g_forest(tbl)
}
\arguments{
\item{tbl}{(\code{gtsummary})\cr
A 'gtsummary' object (e.g., from \code{\link[gtsummary:tbl_regression]{gtsummary::tbl_regression()}}).}
}
\value{
A combined 'ggplot' object (likely a 'patchwork' object)
showing the table on the left and the forest plot on the right.
}
\description{
This is the main wrapper function that takes a 'gtsummary' object,
converts it to a 'ggplot' table, extracts the necessary data, creates
a forest plot, and combines the two plots side-by-side using \code{+}.
This likely relies on the \code{patchwork} package for plot combination.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) withAutoprint(\{ # examplesIf}
tbl <-
  trial |>
  tbl_roche_subgroups(
    rsp = "response",
    by = "trt",
    subgroups = c("grade", "stage"),
    ~ glm(response ~ trt, data = .x) |>
      gtsummary::tbl_regression(
        show_single_row = trt,
        exponentiate = TRUE
      )
  )
\dontrun{
g_forest(tbl)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=extract_plot_data]{extract_plot_data()}}, \code{\link[=gg_forest_plot]{gg_forest_plot()}}
}
