% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_options_pbs.R
\name{crew_options_pbs}
\alias{crew_options_pbs}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} PBS options.}
\usage{
crew_options_pbs(
  verbose = FALSE,
  command_submit = as.character(Sys.which("qsub")),
  command_terminate = NULL,
  script_directory = tempdir(),
  script_lines = character(0L),
  cwd = TRUE,
  log_output = "/dev/null",
  log_error = NULL,
  log_join = TRUE,
  memory_gigabytes_required = NULL,
  cores = NULL,
  walltime_hours = 12
)
}
\arguments{
\item{verbose}{Logical, whether to see console output and error messages
when submitting worker.}

\item{command_submit}{Character of length 1,
file path to the executable to submit a worker job.}

\item{command_terminate}{Deprecated on 2025-08-26 in
\code{crew.cluster} version 0.3.8.9001. No longer needed.}

\item{script_directory}{Character of length 1, directory path to the
job scripts. Just before each job submission, a job script
is created in this folder. Script base names are unique to each
launcher and worker, and the launcher deletes the script when the
worker is manually terminated. \code{tempdir()} is the default, but it
might not work for some systems.
\code{tools::R_user_dir("crew.cluster", which = "cache")}
is another reasonable choice.}

\item{script_lines}{Optional character vector of additional lines to be
added to the job script just after the more common flags.
An example would be \code{script_lines = "module load R"} if your cluster
supports R through an environment module.}

\item{cwd}{Logical of length 1, whether to set the working directory
of the worker to the working directory it was launched from.
\code{cwd = TRUE} is translates to a line of \verb{cd "$O_WORKDIR"}
in the job script. This line is inserted after the content of
\code{script_lines} to make sure the \verb{#PBS} directives are above
system commands. \code{cwd = FALSE} omits this line.}

\item{log_output}{Character of length 1, file or directory path to PBS
worker log files for standard output.
\code{log_output = "VALUE"} translates to a line of
\verb{#PBS -o VALUE} in the PBS job script. The default is \verb{/dev/null} to omit
the logs. If you do supply a non-\verb{/dev/null} value,
it is recommended to supply a
directory path with a trailing slash so that each worker gets its own set
of log files.}

\item{log_error}{Character of length 1, file or directory path to PBS
worker log files for standard error.
\code{log_error = "VALUE"} translates to a line of
\verb{#PBS -e VALUE} in the PBS job script.
The default of \code{NULL} omits this line.
If you do supply a non-\verb{/dev/null} value, it is recommended to supply a
directory path with a trailing slash so that each worker gets its own set
of log files.}

\item{log_join}{Logical, whether to join the stdout and stderr log
files together into one file. \code{log_join = TRUE} translates to a line
of \verb{#PBS -j oe} in the PBS job script, while \code{log_join = FALSE} is
equivalent to \verb{#PBS -j n}. If \code{log_join = TRUE}, then \code{log_error}
should be \code{NULL}.}

\item{memory_gigabytes_required}{Optional positive numeric scalar,
gigabytes of memory required to run the worker.
\code{memory_gigabytes_required = 2.4}
translates to a line of \verb{#PBS -l mem=2.4gb} in the PBS job script.
\code{memory_gigabytes_required = NULL} omits this line.}

\item{cores}{Optional positive integer scalar,
number of cores for the worker
("slots" in PBS lingo).
\code{cores = 4} translates
to a line of \verb{#PBS -l ppn=4} in the PBS job script.
\code{cores = NULL} omits this line.}

\item{walltime_hours}{Numeric scalar,
hours of wall time
to request for the worker. \code{walltime_hours = 23} translates to
a line of \verb{#PBS -l walltime=23:00:00} in the job script.
\code{walltime_hours = NULL} omits this line.}
}
\value{
A classed list of options.
}
\description{
Set options for PBS job management.
}
\section{Retryable options}{

Retryable options are deprecated in \code{crew.cluster} as of
2025-01-27 (version \verb{0.3.4}).
}

\section{Attribution}{

The template files at
\url{https://github.com/mschubert/clustermq/tree/master/inst}
informed the development of the \code{crew} launcher plugins in
\code{crew.cluster}, and we would like to thank
Michael Schubert for developing \code{clustermq} and releasing it under
the permissive Apache License 2.0.
See the \code{NOTICE} and \code{README.md} files in the \code{crew.cluster}
source code for additional attribution.
}

\examples{
  crew_options_pbs()
}
\seealso{
Other pbs: 
\code{\link{crew_class_launcher_pbs}},
\code{\link{crew_controller_pbs}()},
\code{\link{crew_launcher_pbs}()}
}
\concept{pbs}
