% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRISP_functions.R
\name{crisp}
\alias{crisp}
\title{Convex Regression with Interpretable Sharp Partitions (CRISP).}
\usage{
crisp(y, X, q = NULL, lambda.min.ratio = 0.01, n.lambda = 50,
  lambda.seq = NULL, rho = 0.1, e_abs = 10^-4, e_rel = 10^-3,
  varyrho = TRUE, double.run = FALSE)
}
\arguments{
\item{y}{An n-vector containing the response.}

\item{X}{An n x 2 matrix with each column containing a covariate.}

\item{q}{The desired granularity of the CRISP fit, \code{M.hat}, which will be a \code{q} by \code{q} matrix. \code{M.hat}
is a mean matrix whose element \code{M.hat[i,j]} contains the mean for pairs of covariate values within a quantile range
of the observed predictors \code{X[,1]} and \code{X[,2]}. For example, \code{M.hat[1,2]} represents the
mean of the observations with the first covariate value less than the \code{1/q}-quantile of \code{X[,1]},
and the second covariate value between the \code{1/q}- and \code{2/q}-quantiles of \code{X[,2]}.
If left \code{NULL}, then \code{q=n} is used when n<100, and \code{q=100} is used when n>=100.
We recommend using \code{q<=100} as higher values take longer to fit and provide an unneeded amount of granularity.}

\item{lambda.min.ratio}{The smallest value for \code{lambda.seq}, as a fraction of the maximum lambda value, which is the data-derived
smallest value for which the fit is a constant value. The default is 0.01.}

\item{n.lambda}{The number of lambda values to consider - the default is 50.}

\item{lambda.seq}{A user-supplied sequence of positive lambda values to consider. The typical usage is to calculate
\code{lambda.seq} using \code{lambda.min.ratio} and \code{n.lambda}, but providing \code{lambda.seq} overrides this. If provided,
\code{lambda.seq} should be a decreasing sequence of values, since CRISP relies on warm starts for speed.
Thus fitting the model for a whole sequence of lambda values is often faster than fitting for a single lambda value.}

\item{rho}{The penalty parameter for our ADMM algorithm. The default is 0.1.}

\item{e_abs, e_rel}{Values used in the stopping criterion for our ADMM algorithm, and discussed in Appendix C.2 of the CRISP paper.}

\item{varyrho}{Should \code{rho} be varied from iteration to iteration? This is discussed in Appendix C.3 of the CRISP paper.}

\item{double.run}{The initial complete run of our ADMM algorithm will yield sparsity in z_{1i} and z_{2i}, but not
necessarily exact equality of the rows and columns of \code{M.hat}. If \code{double.run} is \code{TRUE}, then the algorithm
is run a second time to obtain \code{M.hat} with exact equality of the appropriate rows and columns. This issue
is discussed further in Appendix C.4 of the CRISP paper.}
}
\value{
An object of class \code{crisp}, which can be summarized using \code{\link{summary}}, plotted using \code{\link{plot}}, and used to predict outcome values for new covariates using \code{\link{predict}}.
\itemize{
\item{\code{M.hat.list}: }{A list of length \code{n.lambda} giving \code{M.hat} for each value of \code{lambda.seq}.}
\item{\code{num.blocks}: }{A vector of length \code{n.lambda} giving the number of blocks in \code{M.hat} for each value of \code{lambda.seq}.}
\item{\code{obj.vec}: }{A vector of length \code{n.lambda} giving the value of the objective of Eqn (4) in the CRISP paper for each value of \code{lambda.seq}.}
\item{Other elements: }{As specified by the user.}
}
}
\description{
This function implements CRISP, which considers the problem of predicting an outcome variable on the basis of two covariates, using an interpretable yet non-additive model.
CRISP partitions the covariate space into blocks in a data-adaptive way, and fits a mean model within each block. Unlike other partitioning methods,
CRISP is fit using a non-greedy approach by solving a convex optimization problem, resulting in low-variance fits.
More details are provided in Petersen, A., Simon, N., and Witten, D. (2016). Convex Regression with Interpretable Sharp Partitions. Journal of Machine Learning Research, 17(94): 1-31 <http://jmlr.org/papers/volume17/15-344/15-344.pdf>.
}
\examples{
\dontrun{
#See ?'crisp-package' for a full example of how to use this package

#generate data (using a very small 'n' for illustration purposes)
set.seed(1)
data <- sim.data(n = 15, scenario = 2)

#fit model for a range of tuning parameters, i.e., lambda values
#lambda sequence is chosen automatically if not specified
crisp.out <- crisp(X = data$X, y = data$y)
}
}
\seealso{
\code{\link{crispCV}}, \code{\link{plot}}, \code{\link{summary}}, \code{\link{predict}}
}

