% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRISP_functions.R
\name{predict}
\alias{predict}
\alias{predict.crisp}
\alias{predict.crispCV}
\title{Predicts Observations for a New Covariate Matrix using Fit from \code{\link{crisp}} or \code{\link{crispCV}}.}
\usage{
\method{predict}{crisp}(object, new.X, lambda.index, ...)

\method{predict}{crispCV}(object, new.X, ...)
}
\arguments{
\item{object}{An object of class \code{crisp} or \code{crispCV}, which result from running the \code{\link{crisp}} or \code{\link{crispCV}} functions, respectively.}

\item{new.X}{The covariate matrix for which to make predictions.}

\item{lambda.index}{The index for the desired value of lambda, i.e., \code{object$lambda.seq[lambda.index]}.}

\item{...}{Additional arguments to be passed, which are ignored in this function.}
}
\value{
A vector containing the fitted y values for \code{new.X}.
}
\description{
This function makes predictions for a specified covariate matrix for a fit of the class \code{crispCV}, or class \code{crisp} with a user-specified tuning parameter.
}
\details{
The ith prediction is made to be the value of \code{object$M.hat.list[[lambda.index]]} corresponding to the pair of covariates closest (in Euclidean distance) to \code{new.X[i,]}.
}
\examples{
\dontrun{
#See ?'crisp-package' for a full example of how to use this package

#generate data (using a very small 'n' for illustration purposes)
set.seed(1)
data <- sim.data(n = 15, scenario = 2)

#fit model for a range of tuning parameters, i.e., lambda values
#lambda sequence is chosen automatically if not specified
crisp.out <- crisp(X = data$X, y = data$y)
#or fit model and select lambda using 2-fold cross-validation
#note: use larger 'n.fold' (e.g., 10) in practice
crispCV.out <- crispCV(X = data$X, y = data$y, n.fold = 2)

#we can make predictions for a covariate matrix with new observations
#new.X with 20 observations
new.data <- sim.data(n = 20, scenario = 2)
new.X <- new.data$X
#these will give the same predictions:
yhat1 <- predict(crisp.out, new.X = new.X, lambda.index = crispCV.out$index.cv)
yhat2 <- predict(crispCV.out, new.X = new.X)
}
}

