% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsOrdinal-class}
\alias{IncrementsOrdinal-class}
\alias{.IncrementsOrdinal}
\alias{IncrementsOrdinal}
\alias{.DefaultIncrementsOrdinal}
\title{\code{IncrementsOrdinal}}
\usage{
IncrementsOrdinal(grade, rule)

.DefaultIncrementsOrdinal()
}
\arguments{
\item{grade}{(\code{numeric})\cr see slot definition.}

\item{rule}{(\code{Increments})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{IncrementsOrdinal}} is the class for applying a standard \code{Increments} rule to
the results of an ordinal CRM trial.
}
\section{Slots}{

\describe{
\item{\code{grade}}{(\code{integer})\cr the toxicity grade to which the \code{rule} should be
applied.}

\item{\code{rule}}{(\code{Increments})\cr the standard \code{Increments} rule to be applied}
}}

\note{
Typically, end users will not use the \code{.DefaultIncrementsOrdinal()} function.
}
\examples{
IncrementsOrdinal(
  grade = 1L,
  rule = IncrementsRelative(
    intervals = c(0, 20),
    increments = c(1, 0.33)
  )
)
}
