% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-methods.R
\name{maxRecruits}
\alias{maxRecruits}
\alias{maxRecruits,RecruitmentUnlimited-method}
\alias{maxRecruits-RecruitmentUnlimited}
\alias{maxRecruits,RecruitmentRatio-method}
\alias{maxRecruits-RecruitmentRatio}
\title{Calculate Maximum Number of Backfill Patients}
\usage{
maxRecruits(object, active_cohort_size, ...)

\S4method{maxRecruits}{RecruitmentUnlimited}(object, active_cohort_size, ...)

\S4method{maxRecruits}{RecruitmentRatio}(object, active_cohort_size, ...)
}
\arguments{
\item{object}{(\code{Recruitment})\cr the recruitment rule.}

\item{active_cohort_size}{(\code{integer})\cr the current size of the active
dose escalation cohort.}

\item{...}{further arguments (not used).}
}
\value{
The maximum number of backfill patients as an \code{integer}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Calculates the maximum number of backfill patients that can be recruited
based on the recruitment rule and the active cohort size.
}
\section{Functions}{
\itemize{
\item \code{maxRecruits(RecruitmentUnlimited)}: method for \code{RecruitmentUnlimited} class.
Returns a very large number (practically unlimited).

\item \code{maxRecruits(RecruitmentRatio)}: method for \code{RecruitmentRatio} class.
Returns \code{ceiling(ratio * active_cohort_size)}.

}}
\examples{
# Create a RecruitmentUnlimited object
recruitment <- RecruitmentUnlimited()

# Calculate maximum recruits for various active cohort sizes
max_recruits_10 <- maxRecruits(recruitment, active_cohort_size = 10)
print(max_recruits_10) # Returns 1e6

max_recruits_100 <- maxRecruits(recruitment, active_cohort_size = 100)
print(max_recruits_100) # Still returns 1e6 (unlimited)

# With RecruitmentUnlimited, the active_cohort_size is ignored
# Create a RecruitmentRatio object with ratio 0.5
recruitment <- RecruitmentRatio(ratio = 0.5)

# Calculate maximum recruits based on active cohort size
# For active cohort of 10: ceiling(0.5 * 10) = 5
max_recruits_10 <- maxRecruits(recruitment, active_cohort_size = 10)
print(max_recruits_10) # 5

# For active cohort of 7: ceiling(0.5 * 7) = ceiling(3.5) = 4
max_recruits_7 <- maxRecruits(recruitment, active_cohort_size = 7)
print(max_recruits_7) # 4

# For active cohort of 15: ceiling(0.5 * 15) = ceiling(7.5) = 8
max_recruits_15 <- maxRecruits(recruitment, active_cohort_size = 15)
print(max_recruits_15) # 8
}
\seealso{
\code{\link{Recruitment}}, \code{\link{RecruitmentUnlimited}}, \code{\link{RecruitmentRatio}}.
}
