% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossrunem.r
\name{crossrunem}
\alias{crossrunem}
\title{Joint Distribution for Crossings and Runs Using the Empirical Median.}
\usage{
crossrunem(nmax = 100, prec = 120, printn = FALSE)
}
\arguments{
\item{nmax}{max sequence length.}

\item{prec}{mpft precision.}

\item{printn}{logical for progress output.}
}
\value{
nfi, number of sequences with m successes, starting with a success, and
nfn, number of sequences with m successes, not starting with a success.
Three-dimensional Rmpfr arrays for each n up to nmax, with dimensions
n (C=0 to n-1), n (L=1 to n) and n+1 (m=0 to n). For n even and m=n/2,
only nfi, and the part corresponding to C=1 to n-1 and L=1 and m=n/2
is non-zero and should be used.
}
\description{
Joint probability distribution for the number of crossings
C and the longest run L in a sequence of n Bernoulli observations where
the number of successes is fixed at m, m between 0 and n. For fixed n,
the joint distribution is computed for all m, this makes the computation
demanding in terms of time and storage requirements. The joint distribution
is computed separately for sequences where the first observation is, or is
not, a success. The results are mainly intended for use when n is even and
m=n/2, but computation in this case requires that all distributions are
computed previously for all m, for all shorter sequences (lower n). In the
case of even n and m=n/2, the distributions for sequences starting or not
with a success are identical, and only the distribution among sequences
starting with a success is used. In that case, this may be interpreted as
the joint distribution for sequences around the empirical median.
}
\examples{
crem14 <- crossrunem(nmax=14, printn=TRUE)
Rmpfr::asNumeric(crem14$nfi[[14]][,,"m=7"]) # subsets of size 7=14/2
# restricted to possible values of C and L
Rmpfr::asNumeric(crem14$nfi[[14]][-1,1:7,"m=7"]) # same as stored data joint14em
Rmpfr::asNumeric(crem14$nfn[[14]][-1,1:7,"m=7"]) # the same

# subsets of sizes different from 14/2
# size 4, first observation included
Rmpfr::asNumeric(crem14$nfi[[14]][,,"m=4"])
# size 14-4=10, first observation not included
Rmpfr::asNumeric(crem14$nfn[[14]][,,"m=10"]) # the same

}
