% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-export.R
\name{cruts2poly}
\alias{cruts2poly}
\title{cruts2poly function}
\usage{
cruts2poly(
  ncfile,
  poly,
  timeRange = NULL,
  offset = "1900-01-01",
  na.rm = FALSE
)
}
\arguments{
\item{ncfile}{character string giving name and location of the CRUTS time series NetCDF file (if the file you downloaded is zipped, then you will need to extract it)}

\item{poly}{a SpatialPolygonsDataFrame on which to average the variable in question}

\item{timeRange}{vector of length 2 giving the start and end dates in the first and second place. Dates are converted using the function ymd, please refer to the help for this funciton for details on appropriate formats.}

\item{offset}{time offset for CRU TS data}

\item{na.rm}{logical, whether to ignore NA's in averaging, default is FALSE (to be consistent with other R functions in other packages), but option TRUE should probably be used on most occasions}
}
\value{
a polygon with the averaged climate variable
}
\description{
A function to convert Climatic Research Unit Time-Series in NetCDF format to polygonal format, averaging over each region in question.
}
\details{
Data can be obtained from \url{http://catalogue.ceda.ac.uk/uuid/ac4ecbd554d0dd52a9b575d9666dc42d}
}
\examples{
\dontrun{crutsimport(ncfile="my_cruts_file.nc",timeRange=c("2000-01-01","2001-01-01"))}
}
