% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmCIF.R
\name{readmm_CIF}
\alias{readmm_CIF}
\title{Reads and output an mmCIF file}
\usage{
readmm_CIF(filename, message = FALSE)
}
\arguments{
\item{filename}{A character string. The path to a valid
CIF file.}

\item{message}{A logical variable. If TRUE (default) the
function prints a message highlighting
what is included in the cif file.}
}
\value{
A named list. Each name correspond to a valid
        field in the cif.
}
\description{
Reads and output an mmCIF file
}
\examples{
datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"3syu.cif")
lCIF <- readmm_CIF(filename)
print(names(lCIF))
print(lCIF$HEADER$Entry)
print(lCIF$HEADER$Symmtery)
print(lCIF$HEADER$CELL)
print(lCIF$EXP_DETAILS$CRYSTAL_CON$VAL)

}
