% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r6_DBTable_v9.R
\name{validator_field_contents_csfmt_rts_data_v2}
\alias{validator_field_contents_csfmt_rts_data_v2}
\title{Field contents validator for csfmt_rts_data_v2 schema}
\usage{
validator_field_contents_csfmt_rts_data_v2(data)
}
\arguments{
\item{data}{A data.frame or data.table containing the data to validate}
}
\value{
TRUE if data is valid for csfmt_rts_data_v2, FALSE otherwise (with error attribute)
}
\description{
Validates that data contents conform to the csfmt_rts_data_v2 schema specification.
This validator checks that granularity_time and granularity_geo fields contain
valid values according to the surveillance data format requirements for version 2.
}
\examples{
# Valid data for csfmt_rts_data_v2
valid_data_v2 <- data.frame(
  granularity_time = c("date", "isoyearweek", "total"),
  granularity_geo = c("nation", "county", "municip"),
  stringsAsFactors = FALSE
)
validator_field_contents_csfmt_rts_data_v2(valid_data_v2)
}
