\name{intensity}
\alias{intensity}
\encoding{UTF-8}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Compare empirical and theoretical intensity (resource-selection) functions [IN DEVELOPMENT]}
\description{This function plots the empirical and theoretical intensity functions with respect to a covariate of interest.}
\usage{
intensity(data,UD,RSF,R=list(),variable=NULL,empirical=FALSE,level=0.95,ticks=TRUE,
          smooth=TRUE,interpolate=TRUE,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{A \code{telemetry} object.}
  \item{UD}{A \code{UD} object generated by \code{\link{akde}} from the same telemetry object as \code{data}. If weights were optimized in \code{\link{akde}}, then they will be adopted by \code{intensity}.}
%  \item{beta}{Initial guesstimates for regression coefficients (not currently important).}
  \item{RSF}{An iRSF model-fit object from \code{rsf.fit} or \code{rsf.select}.}
  \item{R}{A named list of rasters or time-varying raster stacks [NOT TESTED] to fit Poisson regression coefficients to (under a log link).}
  \item{variable}{Variable of interest from \code{names(R)}.}
  \item{empirical}{Plot an empirical estimate of \eqn{\log\lambda} [IN DEVELOPMENT].}
  \item{level}{Confidence level for intensity function estimates.}
  \item{ticks}{Demark used resource values atop the plot.}
  \item{smooth}{Apply location-error smoothing to the tracking data before regression.}
  \item{interpolate}{Whether or not to interpolate raster values during extraction.}
  \item{...}{Arguments passed to \code{\link{plot}}.}
}

\details{With resepct to the Poisson point process likelihood \eqn{L(\lambda)=\frac{\lambda(x,y)}{\iint \lambda(x',y') \, dx' dy'}}, the \code{formula} object of a ctmm iRSF model corresponds to the covariate dependence of \eqn{\log(\lambda)}, which is typically of the form \eqn{\boldsymbol{\beta} \cdot \mathbf{R}}. \code{intensity} plots both empirical (black) and theoretical (red) estimates of the log-intensity (or log-selection) function \eqn{\log(\lambda)} as a function of the covariate \code{variable}, which provides a visualization of what the true \code{formula} looks like and how the fitted model compares. The empirical estimate is semi-parametric, in that it assumes that \code{RSF} is correct for all variables other than \code{variable}.
}

%\value{}

%\section{Warnings}{}

%\references{}

%\author{ C. H. Fleming }

\note{Only relative differences in \eqn{\log(\lambda)} are meaningful.}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{rsf.fit}}. }

%\examples{}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
