% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{ctgov_query}
\alias{ctgov_query}
\title{Query the ClinicalTrials.gov dataset}
\usage{
ctgov_query(
  data = NULL,
  description_kw = NULL,
  sponsor_kw = NULL,
  brief_title_kw = NULL,
  official_title_kw = NULL,
  criteria_kw = NULL,
  intervention_kw = NULL,
  intervention_desc_kw = NULL,
  outcome_kw = NULL,
  outcome_desc_kw = NULL,
  conditions_kw = NULL,
  population_kw = NULL,
  date_range = NULL,
  enrollment_range = NULL,
  minimum_age_range = NULL,
  maximum_age_range = NULL,
  study_type = NULL,
  allocation = NULL,
  intervention_model = NULL,
  observational_model = NULL,
  primary_purpose = NULL,
  time_perspective = NULL,
  masking_description = NULL,
  sampling_method = NULL,
  phase = NULL,
  gender = NULL,
  sponsor_type = NULL,
  ignore_case = TRUE,
  match_all = FALSE
)
}
\arguments{
\item{data}{a dataset to search over; set to \code{NULL}
to use the full dataset that is currently
loaded}

\item{description_kw}{character vector of keywords to search in the
intervention description field. Set to
\code{NULL} to avoid searching this field.}

\item{sponsor_kw}{character vector of keywords to search in the
sponsor (the company that submitted the study).
Set to \code{NULL} to avoid searching this
field.}

\item{brief_title_kw}{character vector of keywords to search in the
brief title field. Set to
\code{NULL} to avoid searching this field.}

\item{official_title_kw}{character vector of keywords to search in the
official title field. Set to
\code{NULL} to avoid searching this field.}

\item{criteria_kw}{character vector of keywords to search in the
criteria field. Set to
\code{NULL} to avoid searching this field.}

\item{intervention_kw}{character vector of keywords to search in the
intervention names field. Set to
\code{NULL} to avoid searching this field.}

\item{intervention_desc_kw}{character vector of keywords to search in the
intervention description field. Set to
\code{NULL} to avoid searching this field.}

\item{outcome_kw}{character vector of keywords to search in the
outcome measures field. Set to
\code{NULL} to avoid searching this field.}

\item{outcome_desc_kw}{character vector of keywords to search in the
outcome description field. Set to
\code{NULL} to avoid searching this field.}

\item{conditions_kw}{character vector of keywords to search in the
conditions field. Set to
\code{NULL} to avoid searching this field.}

\item{population_kw}{character vector of keywords to search in the
population field. Set to
\code{NULL} to avoid searching this field.}

\item{date_range}{string of length two formatted as "YYYY-MM-DD"
describing the earliest and latest data to
include in the results. Use a missing value
for either value search all dates. Set to
\code{NULL} to avoid searching this field.}

\item{enrollment_range}{numeric of length two describing the smallest
and largest enrollment sizes to
include in the results. Use a missing value
for either value to avoid filtering. Set to
\code{NULL} to avoid searching this field.}

\item{minimum_age_range}{numeric of length two describing the smallest
and largest minmum age (in years) to
include in the results. Use a missing value
for either value to avoid filtering. Set to
\code{NULL} to avoid searching this field.}

\item{maximum_age_range}{numeric of length two describing the smallest
and largest maximum age (in years) to
include in the results. Use a missing value
for either value to avoid filtering. Set to
\code{NULL} to avoid searching this field.}

\item{study_type}{character vector of study types to include
in the output. Set to \code{NULL} to avoid
searching this field.}

\item{allocation}{character vector of allocations to include
in the output. Set to \code{NULL} to avoid
searching this field.}

\item{intervention_model}{character vector of interventions to include
in the output. Set to \code{NULL} to avoid
searching this field.}

\item{observational_model}{character vector of observations to include
in the output. Set to \code{NULL} to avoid
searching this field.}

\item{primary_purpose}{character vector of primary purposes to
include in the output. Set to \code{NULL} to
avoid searching this field.}

\item{time_perspective}{character vector of time perspectives to
include in the output. Set to \code{NULL} to
avoid searching this field.}

\item{masking_description}{character vector of maskings to include
in the output. Set to \code{NULL} to avoid
searching this field.}

\item{sampling_method}{character vector of sampling methods to
include in the output. Set to \code{NULL} to
avoid searching this field.}

\item{phase}{character vector of phases to include
in the output. Set to \code{NULL} to avoid
searching this field.}

\item{gender}{character vector of genders to include
in the output. Set to \code{NULL} to avoid
searching this field.}

\item{sponsor_type}{character vector of sponsor types to include
in the output. Set to \code{NULL} to avoid
searching this field.}

\item{ignore_case}{logical. Should the search ignore
capitalization. The default is \code{TRUE}.}

\item{match_all}{logical. Should the results required matching
all the keywords? The default is \code{FALSE}.}
}
\value{
a tibble object queried from the loaded database
}
\description{
This function selects a subset of the clinical trials data by using a
a variety of different search parameters. These include free text search
keywords, range queries for the continuous variables, and exact matches for
categorical fields. The function \code{ctgov_query_terms} shows the
categorical levels for the latter. The function will either take the entire
dataset loaded into the package environment or a previously queried input.
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
