% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_chemical_lists_by_type}
\alias{get_chemical_lists_by_type}
\title{Get chemical lists by type}
\usage{
get_chemical_lists_by_type(
  type = NULL,
  Projection = "",
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{type}{The type of list. This is a case sensitive parameter and returns
lists only for values of "federal", "international", "state", and "other".}

\item{Projection}{Optional parameter controlling return type. It takes values
'chemicallistall' and 'chemicallistname' with the former as the default
value.}

\item{API_key}{The user-specified API key.}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame containing information about lists that meet the search
criteria.
}
\description{
Get chemical lists by type
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull chemical lists by type
federal <- get_chemical_lists_by_type(type = 'Federal')
\dontshow{\}) # examplesIf}
}
