% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs-batch.R
\name{get_httk_data_batch}
\alias{get_httk_data_batch}
\title{Retrieve httk data via batch search}
\usage{
get_httk_data_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = exposure_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A named list of httk data corresponding to the input chemicals
}
\description{
Retrieve httk data via batch search
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Retrieve information for BPA and Caffeine
dtxsids <- c('DTXSID7020182', 'DTXSID0020232')
httk_data <- get_httk_data_batch(DTXSID = dtxsids)
\dontshow{\}) # examplesIf}
}
