% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection-config.R
\name{set_bounds_check}
\alias{set_bounds_check}
\title{For this connection, set the response when values do not fit into given type before writing.}
\usage{
set_bounds_check(con, bounds_check = "error")
}
\arguments{
\item{con}{Connection object or raw vector. Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{bounds_check}{Default bounds checking behaviour. One of: 'ignore', 'warn', 'error'.
Default: 'error'.
This default may be over-ridden by specifying
the \code{bounds_check} argument when calling individual functions.
\describe{
  \item{\code{ignore}}{No explicit checks will be made for
  out-of-bound values.
  The underlying R functions (e.g. \code{readBin()}, \code{writeBin()}) may still do checking.
  }
  \item{\code{warn}}{Explicit checks will be made for
  out-of-bound values.
  If any are found, then a \code{warning()} will be issued.
  }
  \item{\code{error}}{Explicit checks will be made for
  out-of-bound values.
  If any are found, then a error will be raised.
  }
}}
}
\value{
Modified connection object
}
\description{
For this connection, set the response when values do not fit into given type before writing.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Open a connection and configure it so out-of-bounds values
# will cause a warning only.
con <- rawConnection(as.raw(1:8), "rb")
con <- set_bounds_check(con, bounds_check = "warn")

# This line attempts to read a value from the connection which
# is too large to store in a double precision floating point without
# loss of integer precision.
# Usually this would cause an error to be raised, but the 'bounds_check'
# option has been set to give a warning only.
read_uint64(con, n = 1, promote = "dbl")

close(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Other connection configuration functions: 
\code{\link{set_endian}()},
\code{\link{set_eof_check}()},
\code{\link{set_integer_promotion}()},
\code{\link{set_na_check}()}
}
\concept{connection configuration functions}
