% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_weight.R
\name{ca_pairs}
\alias{ca_pairs}
\title{Generate codon-anticodon pairing relationship}
\usage{
ca_pairs(codon_table = get_codon_table(), domain = "Eukarya", plot = FALSE)
}
\arguments{
\item{codon_table}{a table of genetic code derived from \code{get_codon_table} or
\code{create_codon_table}.}

\item{domain}{The taxonomic domain of interest. "Eukarya" (default), "Bacteria" or "Archaea".}

\item{plot}{FALSE (default) or TRUE. Whether to keep the columns required for plotting.}
}
\value{
a data.table of codon-anticodon pairing information. The columns represent 
the pairing type, codon, corresponding anticodon, and the encoded amino acid when the argument "plot" is FALSE.
}
\description{
\code{ca_pairs} show possible codon-anticodons pairings
}
\examples{
# get possible codon and anticodon pairings for the vertebrate mitochondrial genetic code
ctab <- get_codon_table(gcid = '2')
pairing <- ca_pairs(ctab)
head(pairing)

}
