% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve.R
\name{curvepred}
\alias{curvepred}
\title{Reserve demand curve predicted values}
\usage{
curvepred(x, w, type = "logistic", dummy = NULL)
}
\arguments{
\item{x}{A matrix with the inputs. If there is a constant in the estimated curve, then the first column in \code{x} should be the constant. Next column should be the excess reserves. Additional regressor follow (optional).}

\item{w}{The vector of weights for the desired curve. Estimated using the \code{\link{curveopt}} function.}

\item{type}{The type of the reserve demand curve. This can be any of \code{logistic}, \code{redLogistic}, \code{fixLogistic}, \code{doubleExp}, \code{exponential}, \code{fixExponential}, \code{arctan}, \code{linear}. See details in \code{\link{curve}}}

\item{dummy}{Optional input to signify a regime change (vertical shifts in the curve). Must be a vector of equal length to the rows of \code{x}. If not needed use \code{NULL}.}
}
\value{
Returns a vector of the predicted values.
}
\description{
Provides the predicted values for the reserve demand curve of choice. For general use prefer the
predict() function, which handles the constant internally.
}
\details{
For a description of the parametric curves, see the provided reference. Below we list their functions:
\itemize{
 \item \code{logisitc} (Logistic) \deqn{r_i = \alpha + \kappa / (1 - \beta e^{g(\bm{C}_i)}) + \varepsilon_i}
 \item \code{redLogistic} (Reduced logistic) \deqn{r_i = \alpha + 1 / (1 - \beta e^{g(\bm{C}_i)}) + \varepsilon_i}
 \item \code{fixLogistic} (Fixed logistic) \deqn{r_i = \alpha + 1 / (1 - e^{g(\bm{C}_i)}) + \varepsilon_i}
 \item \code{doubleExp} (Double exponential) \deqn{r_i = \alpha + \beta e^{\rho e^{g(\bm{C}_i)}} + \varepsilon_i}
 \item \code{exponential} (Exponential) \deqn{r_i = \alpha + \beta e^{g(\bm{C}_i)} + \varepsilon_i}
 \item \code{fixExponential} (Fixed exponential) \deqn{r_i = \beta e^{g(\bm{C}_i)} + \varepsilon_i}
 \item \code{arctan} (Arctangent) \deqn{r_i = \alpha + \beta \arctan ( g(\bm{C}_i))  + \varepsilon_i}
 \item \code{linear} (Linear) \deqn{r_i = g(\bm{C}_i) + \varepsilon_i}
}
And \eqn{g(\bm{C}) = c + \bm{C} w_g}, where \eqn{\alpha}, \eqn{\beta}, \eqn{\kappa}, \eqn{\rho} are curve parameters,
\eqn{c} is a constant togglable by \code{constant}, \eqn{\bm{C}} are the regressors including the excess reserves. \eqn{w_g} their coefficients, and finally \eqn{\varepsilon_i} is the error term of the curve.
}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{curve}}, and \code{\link{curveopt}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
