% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npcurve.R
\name{cvnpcurve}
\alias{cvnpcurve}
\title{Cross-validated errors for non-parametric curve}
\usage{
cvnpcurve(x, y, cvIndex, type = "rforest", dummy = NULL)
}
\arguments{
\item{x}{A matrix of explanatory variables. Excess reserve must be the first input.Additional regressor follow (optional).}

\item{y}{A vector of normalised interest rates.}

\item{cvIndex}{A matrix detailing how the sample was split for the cross-validation. Output from \code{\link{cvfit}}.}

\item{type}{The type of the reserve demand curve. This can be any of \code{rforecast} for random forecast or \code{spline} for spline regression.}

\item{dummy}{Optional input to signify a regime change (vertical shifts in the curve). Must be a vector of equal length to the rows of \code{x}. If not needed use \code{NULL}.}
}
\value{
Returns summary cross-validated errors, comparable with the output from  \code{\link{cvfit}}.
}
\description{
Obtain cross-validated errors for a non-parametric curve with given sample splits.
}
\examples{
\donttest{
  # Use ECB example data
  rate <- ecb$rate
  x <- ecb$x[,1:3,drop=FALSE]
  cvKeep <- cvfit(x,rate,folds=5,alltype=c("logistic","arctan"),parallel=TRUE)
  # Get non-parametric curve cross-validated errors
  cvRF <- cvnpcurve(x,rate,cvKeep$cvIndex)
  cvSP <- cvnpcurve(x,rate,cvKeep$cvIndex,type="spline")
}

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{cvfit}}, and \code{\link{cvfitplot}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
