% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve.R
\name{invcurve}
\alias{invcurve}
\title{Calculate the inverse curve prediction}
\usage{
invcurve(
  object,
  ynew = NULL,
  xnew = NULL,
  dummynew = NULL,
  warn = c(TRUE, FALSE)
)
}
\arguments{
\item{object}{A model fit with \code{\link{curve}}.}

\item{ynew}{The input rate. If \code{NULL} this corresponds to the values from \code{predict(object)}.}

\item{xnew}{The values for the additional regressors that were used in the curve fit. Must be a matrix, ordered (columns) as they were input in the fitting of the curve. The constant is dealt with automatically. Do not input the excess reserves. If \code{NULL} this is picked up from the data used to fit the curve.}

\item{dummynew}{The values for the indicator, if one was used in the fitting of the curve. If \code{NULL} then the data used in the fitting of the model are used.}

\item{warn}{A logical (\code{TRUE} or \code{FALSE}) to issue a warning if the resulting values are more than 10\% away from the min-max of the excess reserves used to estimate the curve.}
}
\value{
Returns a vector of values of the predicted reserves
}
\description{
Calculate the predicted reserves given some rate, i.e., calculate the prediction of the inverse curve.
}
\examples{
\dontshow{
  rate <- ecb$rate
  x <- ecb$x[,1,drop=FALSE]
  fit <- curve(x,rate,rep=1,type="fixExponential")
  invcurve(fit)
}
\donttest{
  # Use ECB example data
  rate <- ecb$rate
  x <- ecb$x[,1,drop=FALSE]
  fit <- curve(x,rate,type="logistic")
  invcurve(fit)

  # Use a different input rate
  invcurve(fit,ynew=0.1)
}

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{curve}}, and \code{\link{predict}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
