% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.curvir}
\alias{plot.curvir}
\alias{plot.npcurvir}
\title{Plot method for curvir reserve demand models}
\usage{
\method{plot}{curvir}(
  x,
  ploty = c(FALSE, TRUE),
  plotq = c(TRUE, FALSE),
  usemean = c(FALSE, TRUE),
  prcmp = c(FALSE, TRUE),
  useline = c(FALSE, TRUE),
  main = NULL,
  pch = 20,
  ...
)

\method{plot}{npcurvir}(
  x,
  ploty = c(FALSE, TRUE),
  plotq = c(TRUE, FALSE),
  usemean = c(FALSE, TRUE),
  prcmp = c(FALSE, TRUE),
  useline = c(FALSE, TRUE),
  main = NULL,
  pch = 20,
  ...
)
}
\arguments{
\item{x}{A model fit with \code{\link{curve}}.}

\item{ploty}{Logical (\code{TRUE} or \code{FALSE}) to plot data used for fitting or not.}

\item{plotq}{Logical (\code{TRUE} or \code{FALSE}) to plot intervals.}

\item{usemean}{Logical (\code{TRUE} or \code{FALSE}) to replace all explanatory variables (except from excess reserves) with their mean. It cannot be used if a \code{dummy} is used in the fitting of the curve.}

\item{prcmp}{Logical (\code{TRUE} or \code{FALSE}) to use principal components to project all variables into two dimensions. Requires \code{usemean == FALSE}. This may be useful when multiple explanatory variables are used.}

\item{useline}{Logical (\code{TRUE} or \code{FALSE}) to force line plots when \code{usemean == FALSE} or \code{prcomp == FALSE} and there are many explanatory variables.}

\item{main}{Use to overide the default plot title.}

\item{pch}{Use to overide the dafault marker type for points.}

\item{...}{Additional inputs (currently unused).}
}
\value{
No returned value. Produces a plot of the estimated curve.
}
\description{
Plot a reserve demand curve estimated using \code{\link{curve}}.

Plot a non-parametric reserve demand curve estimated using \code{\link{npcurve}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{plot(curvir)}: Plot parametric curves

\item \code{plot(npcurvir)}: Plot non-parametric curves

}}
\examples{
\dontshow{
  rate <- head(ecb$rate,10)
  x <- ecb$x[1:10,1,drop=FALSE]
  fit <- curve(x,rate,rep=1,type="fixExponential")
  plot(fit)
}
\donttest{
  # Use ECB example data
  rate <- ecb$rate
  x <- ecb$x[,1,drop=FALSE]
  fit <- curve(x,rate)
  plot(fit)
}

# Use ECB example data
rate <- ecb$rate
x <- ecb$x[,1,drop=FALSE]
fit <- npcurve(x,rate)
plot(fit)

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{curve}}.

\code{\link{npcurve}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
