% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Transferable.R
\name{Transferable}
\alias{Transferable}
\alias{Biomass-transfer}
\alias{Transferable-class}
\title{Biomass transfer class}
\description{
By inheriting from class \code{Transferable}, a scenario's behavior can be
extended to support transfer and reset of biomass at dedicated points during
simulation.
}
\section{Slots}{

\describe{
\item{\code{transfer.times}}{\code{numeric}, vector of custom time points at which transfers occur,
e.g. \code{c(2,5,14)}}

\item{\code{transfer.interval}}{\code{numeric}, length of regular interval until biomass transfer to new
medium, regular transfers always occur relative to time point zero}

\item{\code{transfer.biomass}}{\code{numeric}, amount of biomass transferred to new medium}

\item{\code{transfer.comp.biomass}}{\code{character} state variable which describes
biomass}

\item{\code{transfer.comp.scaled}}{\code{character} vector of state variable which will
be scaled 1:1 when biomass is modified, e.g. internal toxicant mass}
}}

\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. \emph{Lemna} effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

If a transfer occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that if transfers are defined using the
\code{interval} argument, the transfers will always occur relative to time point
zero (\code{t = 0}). As an example, setting a regular transfer of seven days,
\code{interval =  7}, will result at transfers occurring at time points which are
integer multiplicates of seven, such as \code{t=0}, \code{t=7}, \code{t=14} and so forth.
The starting and end times of a scenario do not influece \strong{when} a regular
transfer occurs, only \strong{if} it occurs.
}

\examples{
# Simulation without biomass transfers
metsulfuron \%>\%
  set_noexposure() \%>\%
  set_notransfer() \%>\%
  simulate()

# With biomass transfer every 7 days, biomass is reset to 50 *g/m²* on transfer
metsulfuron \%>\%
  set_noexposure() \%>\%
  set_transfer(interval=7, biomass=50) \%>\%
  simulate()
}
\seealso{
\code{\link[=set_transfer]{set_transfer()}}

Other scenario-related: 
\code{\link{Scenarios}}
}
\concept{scenario-related}
