% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_seasons.R
\name{select_seasons}
\alias{select_seasons}
\title{Select the number of  mortality seasons}
\usage{
select_seasons(x, max.season = 4, lrt = FALSE, print = TRUE)
}
\arguments{
\item{x}{\code{\link{create_cycloSurv}} object}

\item{max.season}{maximum number of seasons to fit}

\item{lrt}{whether or not to perform and return the complete results of nested likelihood ratio tests}

\item{print}{boolean parameter; if TRUE the function prints the table out as a side effect of creating the object}
}
\value{
a list containing (1) a list of all the fitted objects, and (2) an AIC (and, optionally, LRT) summary table.  Also prints both tables by default.
}
\description{
Compute a delta AIC table (and, optionally, likelihood ratio tests) for a sequence of models with a different number of seasons
}
\examples{
T.morts1 <- simulate_cycloSurv(1000, period = 1, 
                             meanhazard = 0.3, 
                             peaks = c(0.25, 0.75), 
                             durations = c(0.2, 0.1), 
                             weights = c(0.3, 0.7), 
                             plotme = FALSE)

\donttest{
model_selection = select_seasons(T.morts1, max.season = 4)
summary(model_selection$fits)
}
}
