% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyl_cop_class.R, R/Ccond.R, R/cyl_cubsec.R,
%   R/cyl_quadsec.R, R/cyl_rect_combine.R, R/cyl_rot_combine.R, R/cyl_vonmises.R
\name{ccylcop}
\alias{ccylcop}
\alias{ccylcop,Copula-method}
\alias{ccylcop,cyl_cubsec-method}
\alias{ccylcop,cyl_quadsec-method}
\alias{ccylcop,cyl_rect_combine-method}
\alias{ccylcop,cyl_rot_combine-method}
\alias{ccylcop,cyl_vonmises-method}
\title{Conditional Distributions of Circular-Linear Copulas}
\usage{
ccylcop(u, copula, cond_on = 2, inverse = FALSE, ...)

\S4method{ccylcop}{Copula}(u, copula, cond_on, inverse)

\S4method{ccylcop}{cyl_cubsec}(u, copula, cond_on = 2, inverse = FALSE)

\S4method{ccylcop}{cyl_quadsec}(u, copula, cond_on = 2, inverse = FALSE)

\S4method{ccylcop}{cyl_rect_combine}(u, copula, cond_on = 2, inverse = FALSE)

\S4method{ccylcop}{cyl_rot_combine}(u, copula, cond_on = 2, inverse = FALSE)

\S4method{ccylcop}{cyl_vonmises}(u, copula, cond_on = 2, inverse = FALSE)
}
\arguments{
\item{u}{\link[base]{matrix} (or \link[base]{vector}) of \link[base]{numeric}
values in \eqn{[0,1]^2}, containing as first column
 the circular (periodic) and as second the linear dimension.}

\item{copula}{\R object of class '\code{\linkS4class{cyl_copula}}'.
or '\code{\link[copula:Copula-class]{Copula}}' (package '\pkg{copula}', only 2-dimensional).}

\item{cond_on}{column number of \code{u} on which the copula is conditioned. E.g if
\code{cond_on = 2}, the function calculates for each element in the first
column of \code{u} the copula conditional on the corresponding element in the
second column.}

\item{inverse}{\link[base]{logical} indicating whether the inverse of the conditional copula is
calculated.}

\item{...}{additional arguments.}
}
\value{
A vector containing the values of the distribution of the copula at
\code{u[,-cond_on]} conditional on the values of \code{u[,cond_on]}.
}
\description{
Calculates the conditional distributions and their inverses of circular-linear
copulas and 2-dimensional linear-linear copulas.
}
\details{
This is a generic that calls the function \code{copula::\link[copula]{cCopula}()}
for 2-dimensional '\code{\link[copula:Copula-class]{Copula}}' objects from the '\pkg{copula}'
package for which \code{copula::\link[copula]{cCopula}()} is available. If
\code{copula::\link[copula]{cCopula}()} is not available, the conditional copula is
calculated numerically. For '\code{\linkS4class{cyl_copula}}' objects,
the conditional copula is calculated analytically or numerically
(depending on the copula and  the values of \code{u}).
Note that the input arguments and the
output of \code{cylcop::ccylcop()} differ from those of
\code{copula::\link[copula]{cCopula}()}.
}
\examples{
cop <- cyl_quadsec(0.1)
#calculate C_u(v) with u = 0.1 and v = 0.5
cylcop::ccylcop(u = c(0.1, 0.5), copula = cop, cond_on = 1, inverse = FALSE)
#calculate C^-1_v(u) with u = 0.1 and v = 0.5 and with u = 0.4 and v = 0.2
cylcop::ccylcop(u = rbind(c(0.1, 0.5), c(0.4, 0.2)), copula = cop, cond_on = 2, inverse = TRUE)

}
\references{
\insertRef{Nelsen2006}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{copula::\link[copula]{cCopula}()}
}
