% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{half2full_circ}
\alias{half2full_circ}
\title{Convert Angle from Half Circle to Full Circle}
\usage{
half2full_circ(angle)
}
\arguments{
\item{angle}{\link[base]{numeric} value of an angle or a
\code{\link[circular]{circular}}-object in \eqn{[-\pi, \pi)}.}
}
\value{
The \link[base]{numeric} value of the angle in \eqn{[0, 2\pi)}.
}
\description{
Converts an angle from the half circle (i.e. in the interval \eqn{[-\pi, \pi)})
to an angle on the full circle  (i.e. in the interval \eqn{[0, 2\pi)}).
}
\examples{
half2full_circ(-1 * pi) / pi
half2full_circ(-0.5 * pi) / pi
half2full_circ(-0 * pi) / pi
half2full_circ(0.5 * pi) / pi

}
