% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_distr.R
\name{joint}
\alias{joint}
\alias{rjoint}
\alias{pjoint}
\alias{djoint}
\title{Density, Distribution, Quantiles and Random Number Generation for joint
distributions}
\usage{
rjoint(n, copula, marginal_1, marginal_2)

djoint(x, copula, marginal_1, marginal_2)

pjoint(q, copula, marginal_1, marginal_2)
}
\arguments{
\item{n}{\link[base]{integer} value, the number of random samples to be
generated with \code{rjoint()}.}

\item{copula}{\R object of class '\code{\linkS4class{cyl_copula}}'.
or '\code{\link[copula:Copula-class]{Copula}}' (package '\pkg{copula}', only 2-dimensional).}

\item{marginal_1}{named \link[base]{list} (for parametric estimates) or
a '\code{\link[stats]{density}}' object (for linear kernel density estimates)
or a '\code{\link[circular]{density.circular}}' object (for circular kernel density estimates).
The output of functions \code{\link{fit_angle}()} and \code{\link{fit_steplength}()}
can be used here directly.}

\item{marginal_2}{This input is similar to \code{marginal_1}.}

\item{x}{\link[base]{matrix} (or \link[base]{vector}) of \link[base]{numeric}
values giving the points (in 2 dimensions) where the density function is evaluated.}

\item{q}{\link[base]{matrix} (or \link[base]{vector}) of \link[base]{numeric}
 values giving the points (in 2 dimensions) where
the distribution function is evaluated.}
}
\value{
\itemize{
\item\code{djoint()} gives a \link[base]{vector} of length \code{length(x)}
 containing the density at \code{x}.
\item\code{pjoint()} gives a
\link[base]{vector} of length \code{length(q)} containing
the distribution function at the corresponding values of \code{q}.
\item\code{rjoint()} generates a \link[base]{vector} of length \code{n}
containing the random samples.
}
}
\description{
The bivariate joint distributions are described in terms of two marginal
distributions and a copula
}
\details{
If entered "by hand", the named lists describing the parametric distributions
(\code{marginal_1} and \code{marginal_2}) must contain 2 entries:
\enumerate{
   \item{\code{name}:
a \link[base]{character} string denoting the name of the distribution.
For a circular distribution, it can be \code{"vonmises"}, \code{"vonmisesmix"}, or
  \code{"wrappedcauchy"}. For a linear distribution, it must be a
  string denoting the name of a linear distribution in the environment, i.e. the name of its
   distribution function without the "p",
  e.g. "norm" for normal distribution}
   \item{\code{coef}: For a circular distribution \code{coef} is a (named) \link[base]{list} of
parameters of the circular
marginal distribution as taken by the functions
\code{\link[circular]{qvonmises}()}, \code{\link{qvonmisesmix}()},
or \code{\link{qwrappedcauchy}()}. For a linear distribution, \code{coef} is
a named list containing the parameters of the distribution given in \code{"name"}.}
}
}
\examples{
cop <- copula::normalCopula(0.6)
marginal_1 <- list(name="exp",coef=list(rate=2))
marginal_2 <- list(name="lnorm", coef=list(0,0.1))

sample <- rjoint(10,cop,marginal_1,marginal_2)
pjoint(sample,cop,marginal_1,marginal_2)
djoint(sample,cop,marginal_1,marginal_2)

cop <- cyl_quadsec()
marginal_1 <- list(name="wrappedcauchy", coef=list(location=0,scale=0.3))
marginal_2 <- list(name="weibull",coef=list(shape=3))

sample <- rjoint(10,cop,marginal_1,marginal_2)
marginal_1 <- fit_angle(theta=sample[,1], parametric=FALSE)
marginal_2 <- fit_steplength(x=sample[,2],parametric="lnorm")
pjoint(c(0.3*pi,4),cop,marginal_1,marginal_2)
djoint(c(0,2),cop,marginal_1,marginal_2)

}
