% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data_admin_init}
\alias{data_admin_init}
\alias{data_admin_authorise}
\alias{data_admin_list_requests}
\alias{data_admin_list_keys}
\title{Encrypted data administration}
\usage{
data_admin_init(path_data, path_user = NULL, quiet = FALSE)

data_admin_authorise(
  path_data = NULL,
  hash = NULL,
  path_user = NULL,
  yes = FALSE,
  quiet = FALSE
)

data_admin_list_requests(path_data = NULL)

data_admin_list_keys(path_data = NULL)
}
\arguments{
\item{path_data}{Path to the data set.  We will store a bunch of
things in a hidden directory within this path.  By default in
most functions we will search down the tree until we find the
.cyphr directory}

\item{path_user}{Path to the directory with your ssh key.
Usually this can be omitted.}

\item{quiet}{Suppress printing of informative messages.}

\item{hash}{A vector of hashes to add.  If provided, each hash can
be the binary or string representation of the hash to add.  Or
omit to add each request.}

\item{yes}{Skip the confirmation prompt?  If any request is
declined then the function will throw an error on exit.}
}
\description{
Encrypted data administration; functions for setting up, adding
users, etc.
}
\details{
\code{data_admin_init} initialises the system; it will create a
data key if it does not exist and authorise you.  If it already
exists and you do not have access it will throw an error.

\code{data_admin_authorise} authorises a key by creating a key to
the data that the user can use in conjunction with their personal
key.

\code{data_admin_list_requests} lists current requests.

\code{data_admin_list_keys} lists known keys that can access the
data.  Note that this is \emph{not secure}; keys not listed here
may still be able to access the data (if a key was authorised and
moved elsewhere for example).  Conversely, if the user has deleted
or changed their key they will not be able to access the data
despite the key being listed here.
}
\examples{

# The workflow here does not really lend itself to an example,
# please see the vignette instead.

# First we need a set of user ssh keys.  In a non example
# environment your personal ssh keys will probably work well, but
# hopefully they are password protected so cannot be used in
# examples.  The password = FALSE argument is only for testing,
# and should not be used for data that you care about.
path_ssh_key <- tempfile()
cyphr::ssh_keygen(path_ssh_key, password = FALSE)

# Initialise the data directory, using this key path.  Ordinarily
# the path_user argument would not be needed because we would be
# using your user ssh keys:
path_data <- tempfile()
dir.create(path_data, FALSE, TRUE)
cyphr::data_admin_init(path_data, path_user = path_ssh_key)

# Now you can get the data key
key <- cyphr::data_key(path_data, path_user = path_ssh_key)

# And encrypt things with it
cyphr::encrypt_string("hello", key)

# See the vignette for more details.  This is not the best medium
# to explore this.

# Cleanup
unlink(path_ssh_key, recursive = TRUE)
unlink(path_data, recursive = TRUE)
}
\seealso{
\code{\link[=data_request_access]{data_request_access()}} for requesting access
to the data, and and \code{data_key} for using the data
itself.  But for a much more thorough overview, see the vignette
(\code{vignette("data", package = "cyphr")}).
}
