% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encrypt_wrapper.R
\name{rewrite_register}
\alias{rewrite_register}
\title{Register functions to work with encrypt/decrypt}
\usage{
rewrite_register(package, name, arg, fn = NULL)
}
\arguments{
\item{package}{The name of the package with the function to
support (as a scalar character).  If your function has no
package (e.g., a function you are working on outside of a
package, use "" as the name).}

\item{name}{The name of the function to support.}

\item{arg}{The name of the argument in the target function that
refers to the file that should be encrypted or decrypted.  This
is the value you would pass through to \code{file_arg} in
\link{encrypt}.}

\item{fn}{Optional (and should be rare) argument used to work
around functions that pass all their arguments through to a
second function as dots.  This is how \code{read.csv} works.  If
needed this function is a length-2 character vector in the form
"package", "name" with the actual function that is used.  But
this should be very rare!}
}
\description{
Add information about argument rewriting so that they can be used
with \link{encrypt} and \link{decrypt}.
}
\details{
If your package uses cyphr, it might be useful to add this as
an \code{.onLoad()} hook.
}
\examples{
# The saveRDS function is already supported.  But if we wanted to
# support it we could look at the arguments for the function:
args(saveRDS)
# The 'file' argument is the one that refers to the filename, so
# we'd write:
cyphr::rewrite_register("base", "saveRDS", "file")
# It's non-API but you can see what is supported in the package by
# looking at
ls(cyphr:::db)
}
