% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{stats.options}
\alias{stats.options}
\title{Helper to get, set, or reset package-global options for statistics}
\usage{
stats.options(...)
}
\arguments{
\item{...}{input, see Details below}
}
\value{
Depending on usage:
\itemize{
\item Full list of options (if no input),
\item A specific option value (if string input),
\item Invisibly \code{NULL} (if setting or resetting options).
}
}
\description{
Internal utility to manage global options for the package via the
"stats.dRiftDM" option slot.
}
\details{
Usage patterns:
\itemize{
\item \code{stats.options()}:
Returns the full list of currently stored options.
\item \code{stats.options(name)}:
Returns the value of a specific option (must be a single unnamed string).
\item \code{stats.options(name = value, ...)}:
Sets (or updates) named option(s).
\item \code{stats.options(NULL)}:
Resets (clears) the entire option list.
}

This function is intended for internal use only.
It behaves similarly to \code{\link[=options]{options()}} and keeps all package-specific options
in a single named list under \code{getOption("stats.dRiftDM")}.

Setting an argument can only be done once with this function, any additional
attempts to modify an option will not work (unless this argument is
explicitly set to \code{NULL}).
}
\keyword{internal}
