% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_bayes_estimate.R
\name{estimate_bayes_h}
\alias{estimate_bayes_h}
\alias{estimate_bayes_one_subj}
\title{(Hierarchical) Bayesian Estimation with Differential Evolution}
\usage{
estimate_bayes_h(
  drift_dm_obj,
  obs_data_ids,
  sampler,
  n_chains,
  burn_in,
  samples,
  n_cores,
  prob_migration,
  prob_re_eval,
  verbose,
  seed = NULL,
  ...
)

estimate_bayes_one_subj(
  drift_dm_obj,
  sampler,
  n_chains,
  burn_in,
  samples,
  prob_migration,
  prob_re_eval,
  verbose,
  ...
)
}
\arguments{
\item{drift_dm_obj}{an object of type \link{drift_dm}.}

\item{obs_data_ids}{data.frame for the hierarchical case. An additional
column ID is necessary that codes the individuals (see also
\link{obs_data}).}

\item{sampler}{character string, indicating the sampler to use.
Must be either \code{"DE-MCMC"} (default) or \code{"TIDE"}.}

\item{n_chains}{numeric, number of chains for the MCMC-sampler.
Default is \code{40}.}

\item{burn_in}{numeric, number of burn-in iterations. Default is \code{500}.}

\item{samples}{numeric, number of sampling iterations after burn-in.
Default is \code{2000}.}

\item{n_cores}{numeric, number of threads to use for parallel processing in
the hierarchical case. Default is \code{1}.}

\item{prob_migration}{numeric, probability of performing a migration
crossover step during burn-in. Default is \code{0.1} (i.e., 10\%).}

\item{prob_re_eval}{numeric, probability of re-evaluating the
likelihood/posterior values of the previous iteration \code{i-1} when deciding
for the acceptance of the proposal in iteration \code{i}. Only considered during
burn-in. Default is \code{0.1} (i.e., 10\%).}

\item{verbose}{integer, indicating verbosity of output: 0 (none),
1 (minimal text output), or 2 (text output and progress bar). Default is \code{2}.}

\item{seed}{optional random seed for reproducibility.}

\item{...}{additional arguments passed to
\link{get_default_prior_settings} to customize prior settings.}
}
\value{
A named ist containing posterior samples for
group-level and individual-level parameters, log-posterior values,
and log-likelihoods. Labels: \code{phi}, \code{pis_phi}, \code{lls_phi}, \code{theta},
\code{pis_theta}, \code{lls_theta}. The first three entries are only present in the
hierarchical case.

The list also has an additional attribute named \code{data_model}. In the
hierarchical case, the attribute contains a named list of model copies
with all the individual data sets attached. The list is named according to
the individual \code{ID}s in the argument \code{obs_data_ids}. In the
non-hierarchical case, the attribute contains the model and its attached
data.
}
\description{
Estimate group-level and individual-level parameters with a
hierarchical Bayesian approach using Differential Evolution MCMC (DE-MCMC)
\insertCite{Turneretal.2013;textual}{dRiftDM}.
An approximation of the marginal likelihood to calculate Bayes Factors can
be obtained with the Thermodynamic Integration via Differential Evolution
(TIDE) sampler \insertCite{EvansAnnis2019;textual}{dRiftDM}.
}
\details{
The function \code{estimate_bayes_h()} handles the hierarchical case. The function
\code{estimate_bayes_one_subj()} handles the case for estimating a single
individual. The reason for writing two functions is that the hierarchical
case has some unique tweaks to it that need to be considered ... and writing
one function would be quite the mess.

Prior Settings: See the wrapper \code{\link[=estimate_bayesian]{estimate_bayesian()}} and
also \code{\link[=get_default_prior_settings]{get_default_prior_settings()}}
}
\references{
\insertRef{Turneretal.2013}{dRiftDM}
\insertRef{EvansAnnis2019}{dRiftDM}
}
\keyword{internal}
