% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_mlp.R
\name{reg_mlp}
\alias{reg_mlp}
\title{MLP for regression}
\usage{
reg_mlp(attribute, size = NULL, decay = 0.05, maxit = 1000)
}
\arguments{
\item{attribute}{attribute target to model building}

\item{size}{number of neurons in hidden layers}

\item{decay}{decay learning rate}

\item{maxit}{number of maximum iterations for training}
}
\value{
returns a object of class \code{reg_mlp}
}
\description{
Multi-Layer Perceptron regression using \code{nnet::nnet} (single hidden layer).
}
\details{
Feedforward neural network with \code{size} hidden units and L2 regularization controlled by \code{decay}.
Data should be scaled for stable training.
}
\examples{
data(Boston)
model <- reg_mlp("medv", size=5, decay=0.54)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, Boston)
train <- sr$train
test <- sr$test

model <- fit(model, train)

test_prediction <- predict(model, test)
test_predictand <- test[,"medv"]
test_eval <- evaluate(model, test_predictand, test_prediction)
test_eval$metrics
}
\references{
Bishop, C. M. (1995). Neural Networks for Pattern Recognition. Oxford University Press.
}
