% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_lstm_e.R
\name{autoenc_lstm_e}
\alias{autoenc_lstm_e}
\title{LSTM Autoencoder - Encode}
\usage{
autoenc_lstm_e(
  input_size,
  encoding_size,
  batch_size = 32,
  num_epochs = 50,
  learning_rate = 0.001
)
}
\arguments{
\item{input_size}{input size}

\item{encoding_size}{encoding size}

\item{batch_size}{size for batch learning}

\item{num_epochs}{number of epochs for training}

\item{learning_rate}{learning rate}
}
\value{
A \code{autoenc_lstm_e} object.
}
\description{
Creates a deep learning LSTM-based autoencoder to encode sequences of observations.
Wraps a PyTorch implementation.
}
\examples{
\dontrun{
# LSTM-based encoder over sequences stored as rows
X <- matrix(rnorm(1000), nrow = 50, ncol = 20)
ae <- autoenc_lstm_e(input_size = 20, encoding_size = 5, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)
Z  <- daltoolbox::transform(ae, X)  # 50 x 5
dim(Z)
}

# See:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_lstm_e.md
}
\references{
Hochreiter, S., & Schmidhuber, J. (1997). Long Short-Term Memory.
}
