% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sim.relatedness.R
\name{gl.sim.relatedness}
\alias{gl.sim.relatedness}
\title{Simulate relatedness estimates.}
\usage{
gl.sim.relatedness(
  x,
  rel = "full.sib",
  nboots = 10,
  emibd9.path = getwd(),
  conf = 0.95,
  iseed = 42,
  plot.out = TRUE,
  plot.dir = NULL,
  plot.file = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{rel}{The degree of relatedness you wish to simulate. One of, 'full.sib', 
'half.sib','first.cousin' [default 'full.sib'].}

\item{nboots}{The number of simulation replicates you wish to perform [default 10].}

\item{emibd9.path}{The location of all necessary files to run EMIBD9 (read more at gl.run.EMIBD9)}

\item{conf}{The specified threshold for confidence interval calculation from simulated relatedness values [default 0.95]}

\item{iseed}{An integer used to seed the random number generator [default 42].}

\item{plot.out}{A boolean that indicates whether to plot the results [default TRUE].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified by the global working directory or tempdir()]}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity]}
}
\value{
Summary statistics of chosen relatedness relationship and a histogram of relatedness values showing the mean.
}
\description{
A simulation based tool to estimate different degrees of relatedness using
genlight object to bootstrap the results of kinship estimates. This method 
uses EMIBD9 (Wang, J. 2022).

Below is a table modified from Speed & Balding (2015) showing kinship values,
and their confidence intervals (CI), for different relationships that could 
be used to guide the choosing of the relatedness threshold in the function.

|Relationship                               |Kinship  |     95% CI       |

|Identical twins/clones/same individual     | 0.5     |        -         |

|Sibling/Parent-Offspring                   | 0.25    |    (0.204, 0.296)|

|Half-sibling                               | 0.125   |    (0.092, 0.158)|

|First cousin                               | 0.062   |    (0.038, 0.089)|

|Unrelated                                  | 0       |        -         |
}
\examples{
\dontrun{
#To run this function needs EMIBD9 installed in your computer
}

}
\references{
\itemize{
\item Wang, J. (2022). A joint likelihood estimator of relatedness and allele
 frequencies from a small sample of individuals. Methods in Ecology and
 Evolution, 13(11), 2443-2462.
 
 Speed, D., Balding, D. Relatedness in the post-genomic era: is it still useful?. Nat
 Rev Genet 16, 33–44 (2015). 
}
}
\author{
Custodian: Sam Amini -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
