% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importRDB1.R
\name{importRDB1}
\alias{importRDB1}
\title{Function to return data from the NWIS RDB 1.0 format}
\usage{
importRDB1(obs_url, asDateTime = TRUE, convertType = TRUE, tz = "UTC")
}
\arguments{
\item{obs_url}{character containing the url for the retrieval or a file path to the data file.}

\item{asDateTime}{logical, if \code{TRUE} returns date and time as POSIXct, if \code{FALSE}, Date}

\item{convertType}{logical, defaults to \code{TRUE}. If \code{TRUE}, the
function will convert the data to dates, datetimes,
numerics based on a standard algorithm. If false, everything is returned as a character}

\item{tz}{character to set timezone attribute of datetime. Default converts the datetimes to UTC
(properly accounting for daylight savings times based on the data's provided tz_cd column).
Recommended US values include "UTC", "America/New_York", "America/Chicago", "America/Denver",
"America/Los_Angeles",  "America/Anchorage", "America/Honolulu", "America/Jamaica", "America/Managua",
"America/Phoenix", and "America/Metlakatla".
For a complete list, see \url{https://en.wikipedia.org/wiki/List_of_tz_database_time_zones}}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
agency_cd \tab character \tab The NWIS code for the agency reporting the data\cr
site_no \tab character \tab The USGS site number \cr
datetime \tab POSIXct \tab The date and time of the value converted to
UTC (if asDateTime = \code{TRUE}), \cr
\tab character \tab or raw character string (if asDateTime = FALSE) \cr
tz_cd \tab character \tab The time zone code for datetime \cr
code \tab character \tab Any codes that qualify the corresponding value\cr
value \tab numeric \tab The numeric value for the parameter \cr
tz_cd_reported \tab The originally reported time zone \cr
}
Note that code and value are repeated for the parameters requested. The names are of the form
XD_P_S, where X is literal,
D is an option description of the parameter,
P is the parameter code,
and S is the statistic code (if applicable).
If a date/time (dt) column contained incomplete date and times, a new column
of dates and time was inserted. This could happen
when older data was reported as dates, and newer data was reported as a date/time.

There are also several useful attributes attached to the data frame:
\tabular{lll}{
Name \tab Type \tab Description \cr
url \tab character \tab The url used to generate the data \cr
queryTime \tab POSIXct \tab The time the data was returned \cr
comment \tab character \tab Header comments from the RDB file \cr
}
}
\description{
This function accepts a url parameter that already contains the desired
NWIS site, parameter code, statistic, startdate and enddate. It is not
recommended to use the RDB format for importing multi-site data.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) withAutoprint(\{ # examplesIf}
site_id <- "02177000"
startDate <- "2012-09-01"
endDate <- "2012-10-01"
offering <- "00003"
property <- "00060"

obs_url <- constructNWISURL(site_id, property,
  startDate, endDate, "dv",
  format = "tsv"
)
\donttest{
data <- importRDB1(obs_url)


urlMultiPcodes <- constructNWISURL("04085427", c("00060", "00010"),
  startDate, endDate, "dv",
  statCd = c("00003", "00001"), "tsv"
)

multiData <- importRDB1(urlMultiPcodes)

unitDataURL <- constructNWISURL(site_id, property,
  "2020-10-30", "2020-11-01", "uv",
  format = "tsv"
) # includes timezone switch

unitData <- importRDB1(unitDataURL, asDateTime = TRUE)

iceSite <- "04024000"
start <- "2015-11-09"
end <- "2015-11-24"
urlIce <- constructNWISURL(iceSite, "00060", start, end, "uv", format = "tsv")

ice <- importRDB1(urlIce, asDateTime = TRUE)
iceNoConvert <- importRDB1(urlIce, convertType = FALSE)
}
# User file:
filePath <- system.file("extdata", package = "dataRetrieval")
fileName <- "RDB1Example.txt"
fullPath <- file.path(filePath, fileName)
importUserRDB <- importRDB1(fullPath)
\dontshow{\}) # examplesIf}
}
