% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nycflights.int}
\alias{nycflights.int}
\title{New York City flights Interval Dataset}
\format{
\describe{
 \item{FlightsDF}{A data frame containing the original 327346 valid (i.e. with non missing values) flights from the nycflights13 package, described by the 4 variables: dep_delay, arr_delay, air_time and distance.}
 \item{FlightsUnits}{A factor with 327346 observations and 142 levels, indicating the month by carrier combination to which each orginal flight belongs to.}
 \item{FlightsIdt}{An IData object with 142 observations and 4 interval-valued variables, describing the intervals formed by agregating the FlightsDF microdata by the 0.05 and 0.95 quantiles of the subsamples formed by FlightsUnits factor.}

}
}
\source{
\url{https://CRAN.R-project.org/package=MAINT.Data}
}
\usage{
data(nycflights.int)
}
\description{
New York City flights interval dataset generated from nycflights dataset.
A interval-valued data set containing 142 units and four interval-valued variables
(dep_delay, arr_delay, air_time and distance), created from from the flights data set in the R package
nycflights13 (on-time data for all flights that departed the JFK, LGA or EWR airports in 2013), after
removing all rows with missing observations, and aggregating by month and carrier.
}
\examples{
data(nycflights.int)
}
\references{
Duarte Silva, A. P., Brito, P., Filzmoser, P., & Dias, J. G. (2021). MAINT. Data: Modelling
and Analysing Interval Data in R. R Journal, 13(2).
}
\keyword{datasets}
