% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{dc_get_dcids_by_name}
\alias{dc_get_dcids_by_name}
\title{Resolve DCIDs from Place Names via Data Commons}
\usage{
dc_get_dcids_by_name(
  names,
  entity_type = NULL,
  api_key = Sys.getenv("DATACOMMONS_API_KEY"),
  base_url = Sys.getenv("DATACOMMONS_BASE_URL", unset =
    "https://api.datacommons.org/v2/"),
  return_type = "json"
)
}
\arguments{
\item{names}{A vector of names or descriptions of the entities to look up.}

\item{entity_type}{Optional string to filter results by \code{typeOf}, such as
\code{"State"} or \code{"City"}. If \code{NULL}, no filter is applied.}

\item{api_key}{Your Data Commons API key. If not provided, uses the
environment variable \code{DATACOMMONS_API_KEY}.}

\item{base_url}{The base URL of the Data Commons API. Defaults to the public
endpoint. For custom deployments, must end with \verb{/core/api/v2/}.}

\item{return_type}{Return format: either \code{"list"} (parsed R object) or
\code{"json"} (JSON string).}
}
\value{
A list or JSON string, depending on \code{return_type}.
}
\description{
Resolves a node (e.g., a place name) to its Data Commons DCID using the
description property. Optionally filters results by entity type.
}
\examples{
\dontshow{if (dc_has_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get the DCID of "Georgia" (ambiguous without type)
dc_get_dcids_by_name(names = "Georgia")

# Get the DCID of "Georgia" as a state
dc_get_dcids_by_name(names = "Georgia", entity_type = "State")

# Get the DCID of "New York City" as a city
dc_get_dcids_by_name(names = "New York City", entity_type = "City")

# Query multiple cities
dc_get_dcids_by_name(
  names = c("Mountain View, CA", "New York City"),
  entity_type = "City"
)
\dontshow{\}) # examplesIf}
}
