% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv_reader.R
\name{csv_reader}
\alias{csv_reader}
\title{Read the CSV-data for a Data Resource}
\usage{
csv_reader(
  path,
  resource,
  use_fread = FALSE,
  convert_categories = c("no", "to_factor"),
  as_connection = FALSE,
  ...
)
}
\arguments{
\item{path}{path to the data set.}

\item{resource}{a Data Resource.}

\item{use_fread}{use the \code{\link[data.table]{fread}} function instead of
\code{\link[utils]{read.csv}} and return a \code{data.table}.}

\item{convert_categories}{how to handle columns for which the field
descriptor has a \code{categories} property. Passed on to
\code{\link{dp_apply_schema}}.}

\item{as_connection}{This argument is ignored. The function will always
return a \code{data.frame}.}

\item{...}{additional arguments are passed on to \code{\link{read.csv}} or
\code{\link[data.table]{fread}}. Note that some arguments are already set
by \code{csv_reader}, so not all arguments are available to use as 
additional arguments.}
}
\value{
Returns a \code{data.frame} with the data.
}
\description{
Read the CSV-data for a Data Resource
}
\seealso{
Generally used by calling \code{\link{dp_get_data}}.
}
