% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decade.R
\name{plot_daily}
\alias{plot_daily}
\title{Plot daily data points}
\usage{
plot_daily(
  dailydata,
  len = 1,
  outfile,
  startyear = NA,
  endyear = NA,
  miss = TRUE,
  units = NA,
  ...
)
}
\arguments{
\item{dailydata}{A character string giving the path of the input file, or
a 5-column matrix with following columns: variable code, year, month, day,  
and the daily value.}

\item{len}{Integer indicating the number of years shown in 
each panel.}

\item{outfile}{Character string giving the path of the output pdf file.}

\item{startyear}{First year to plot. If not indicated, all available years
until \code{endyear} will be plotted.}

\item{endyear}{Last year to plot. If not indicated, all available years
since \code{startyear} will be plotted.}

\item{miss}{If TRUE (the default), missing data are plotted as red crosses at the bottom 
of the plot.}

\item{units}{Character string giving the units (will be printed in the y-axis). If
\code{dailydata} is a path to a file, then the units are read from the SEF header.}

\item{...}{Graphical parameters passed to the function \code{\link{plot}},
such as \code{cex}, \code{lwd}, \code{pch}, \code{col}, etc.
(see \code{\link{par}}).}
}
\description{
Plot daily data points for custom intervals.
}
\details{
The input file must follow the C3S Station Exchange Format (SEF).

Missing data are shown as red dots at the bottom of the plot.
}
\examples{
plot_daily(Rosario$Tx, len = 2, outfile = paste0(tempdir(),"/test.pdf"))

}
\references{
Hunziker et al., 2017: Identifying, attributing, and overcoming common data quality 
issues of manned station observations. Int. J. Climatol, 37: 4131-4145.

Hunziker et al., 2018: Effects of undetected data quality issues on climatological
analyses. Clim. Past, 14: 1-20.
}
\author{
Stefan Hunziker, Yuri Brugnara
}
